"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogRateAnalysisTypeForCounts = getLogRateAnalysisTypeForCounts;
var _log_rate_analysis_type = require("./log_rate_analysis_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Identify the log rate analysis type based on the baseline/deviation doc counts.
 */
function getLogRateAnalysisTypeForCounts({
  baselineCount,
  deviationCount,
  windowParameters
}) {
  const {
    baselineMin,
    baselineMax,
    deviationMin,
    deviationMax
  } = windowParameters;
  const deviationDuration = deviationMax - deviationMin;
  const deviationPerBucket = deviationCount;
  const baselineNormalizedDuration = (baselineMax - baselineMin) / deviationDuration;
  const baselinePerBucket = baselineCount / baselineNormalizedDuration;
  return deviationPerBucket >= baselinePerBucket ? _log_rate_analysis_type.LOG_RATE_ANALYSIS_TYPE.SPIKE : _log_rate_analysis_type.LOG_RATE_ANALYSIS_TYPE.DIP;
}