"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRateAnalysisDocumentCountChartData = void 0;
var _react = require("react");
var _state = require("@kbn/aiops-log-rate-analysis/state");
var _log_rate_analysis_content = require("./log_rate_analysis_content");
var _use_data = require("../../../hooks/use_data");
var _use_data_source = require("../../../hooks/use_data_source");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogRateAnalysisDocumentCountChartData = ({
  timeRange,
  esSearchQuery
}) => {
  const {
    dataView
  } = (0, _use_data_source.useDataSource)();
  const currentSelectedGroup = (0, _state.useCurrentSelectedGroup)();
  const currentSelectedSignificantItem = (0, _state.useCurrentSelectedSignificantItem)();
  const dispatch = (0, _state.useAppDispatch)();
  const {
    documentStats,
    earliest,
    latest,
    intervalMs
  } = (0, _use_data.useData)(dataView, 'log_rate_analysis', esSearchQuery !== null && esSearchQuery !== void 0 ? esSearchQuery : _log_rate_analysis_content.DEFAULT_SEARCH_QUERY, undefined, currentSelectedSignificantItem, currentSelectedGroup, undefined, true, timeRange);

  // TODO Since `useData` isn't just used within Log Rate Analysis, this is a bit of
  // a workaround to pass the result on to the redux store. At least this ensures
  // we now use `useData` only once across Log Rate Analysis! Originally `useData`
  // was quite general, but over time it got quite some specific features used
  // across Log Rate Analysis and Pattern Analysis. We discussed that we should
  // split this up into more specific hooks.
  (0, _react.useEffect)(() => {
    dispatch((0, _state.setDocumentCountChartData)({
      earliest,
      latest,
      intervalMs,
      documentStats
    }));
  }, [documentStats, dispatch, earliest, intervalMs, latest]);
  return null;
};
exports.LogRateAnalysisDocumentCountChartData = LogRateAnalysisDocumentCountChartData;