"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.trackAIOpsRouteUsage = trackAIOpsRouteUsage;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function trackAIOpsRouteUsage(analysisType, source, usageCounter) {
  if (usageCounter && typeof source === 'string') {
    usageCounter.incrementCounter({
      counterName: analysisType,
      counterType: `run_via_${source}`,
      incrementBy: 1
    });
  }
}