"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleTemplateResponseSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _response = require("../../../rule/response");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleTemplateResponseSchema = exports.ruleTemplateResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.string({
    meta: {
      description: 'The identifier for the rule.'
    }
  }),
  name: _configSchema.schema.string({
    meta: {
      description: ' The name of the rule.'
    }
  }),
  tags: _configSchema.schema.arrayOf(_configSchema.schema.string({
    meta: {
      description: 'The tags for the rule.'
    }
  })),
  rule_type_id: _configSchema.schema.string({
    meta: {
      description: 'The rule type identifier.'
    }
  }),
  schedule: _response.ruleResponseSchemaV1.getPropSchemas().schedule,
  params: _response.ruleResponseSchemaV1.getPropSchemas().params,
  alert_delay: _response.ruleResponseSchemaV1.getPropSchemas().alert_delay,
  flapping: _response.ruleResponseSchemaV1.getPropSchemas().flapping
});