"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateIntervalAndFrequency = validateIntervalAndFrequency;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function validateIntervalAndFrequency(every) {
  const everyRegexp = new RegExp(_constants.INTERVAL_FREQUENCY_REGEXP, 'g');
  if (!everyRegexp.test(every)) {
    return `'every' string of recurring schedule is not valid : ${every}`;
  }
  const parsedEvery = _datemath.default.parse(`now-${every}`);
  if (!parsedEvery || !parsedEvery.isValid()) {
    return `Invalid 'every' field conversion to date.`;
  }
  return;
}