"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteMaintenanceWindow = void 0;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@kbn/react-query");
var _kibana_react = require("../utils/kibana_react");
var _delete = require("../services/maintenance_windows_api/delete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDeleteMaintenanceWindow = () => {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana_react.useKibana)().services;
  const mutationFn = ({
    maintenanceWindowId
  }) => {
    return (0, _delete.deleteMaintenanceWindow)({
      http,
      maintenanceWindowId
    });
  };
  return (0, _reactQuery.useMutation)(mutationFn, {
    onSuccess: () => {
      toasts.addSuccess(_i18n.i18n.translate('xpack.alerting.maintenanceWindowsDeleteSuccess', {
        defaultMessage: 'Deleted maintenance window'
      }));
    },
    onError: () => {
      toasts.addDanger(_i18n.i18n.translate('xpack.alerting.maintenanceWindowsDeleteFailure', {
        defaultMessage: 'Failed to delete maintenance window.'
      }));
    }
  });
};
exports.useDeleteMaintenanceWindow = useDeleteMaintenanceWindow;