"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformFindMaintenanceWindowParams = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformFindMaintenanceWindowParams = params => {
  const status = params.status && !Array.isArray(params.status) ? [params.status] : params.status;
  return {
    ...(params.page ? {
      page: params.page
    } : {}),
    ...(params.per_page ? {
      perPage: params.per_page
    } : {}),
    ...(params.search ? {
      search: params.search
    } : {}),
    ...(params.status ? {
      status
    } : {})
  };
};
exports.transformFindMaintenanceWindowParams = transformFindMaintenanceWindowParams;