"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.saveConfig = saveConfig;
var _i18n = require("@kbn/i18n");
var _all_option = require("../../../../../../../common/agent_configuration/all_option");
var _create_call_apm_api = require("../../../../../../services/rest/create_call_apm_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function saveConfig({
  config,
  isEditMode,
  toasts
}) {
  try {
    await (0, _create_call_apm_api.callApmApi)('PUT /api/apm/settings/agent-configuration 2023-10-31', {
      signal: null,
      params: {
        query: {
          overwrite: isEditMode
        },
        body: {
          ...config,
          service: {
            name: (0, _all_option.omitAllOption)(config.service.name),
            environment: (0, _all_option.omitAllOption)(config.service.environment)
          }
        }
      }
    });
    toasts.addSuccess({
      title: _i18n.i18n.translate('xpack.apm.agentConfig.saveConfig.succeeded.title', {
        defaultMessage: 'Configuration saved'
      }),
      text: _i18n.i18n.translate('xpack.apm.agentConfig.saveConfig.succeeded.text', {
        defaultMessage: 'The configuration for "{serviceName}" was saved. It will take some time to propagate to the agents.',
        values: {
          serviceName: (0, _all_option.getOptionLabel)(config.service.name)
        }
      })
    });
  } catch (error) {
    toasts.addDanger({
      title: _i18n.i18n.translate('xpack.apm.agentConfig.saveConfig.failed.title', {
        defaultMessage: 'Configuration could not be saved'
      }),
      text: _i18n.i18n.translate('xpack.apm.agentConfig.saveConfig.failed.text', {
        defaultMessage: 'Something went wrong when saving the configuration for "{serviceName}". Error: "{errorMessage}"',
        values: {
          serviceName: (0, _all_option.getOptionLabel)(config.service.name),
          errorMessage: error.message
        }
      })
    });
  }
}