"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HomeLink = HomeLink;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _environment_filter_values = require("../../../../../common/environment_filter_values");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/links/apm/home_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const defaultQueryParams = {
  kuery: '',
  serviceGroup: '',
  comparisonEnabled: true,
  rangeFrom: 'now-15m',
  rangeTo: 'now',
  environment: _environment_filter_values.ENVIRONMENT_ALL.value
};
function HomeLink(props) {
  const {
    link
  } = (0, _use_apm_router.useApmRouter)();
  const homeLink = link('/services', {
    query: defaultQueryParams
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
    "data-test-subj": "apmHomeLink",
    href: homeLink
  }, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 10
    }
  }));
}