"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEnvironmentsFetcher = useEnvironmentsFetcher;
var _use_fetcher = require("./use_fetcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INITIAL_DATA = {
  environments: []
};
function useEnvironmentsFetcher({
  serviceName,
  start,
  end
}) {
  const {
    data = INITIAL_DATA,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!start || !end) {
      return;
    }
    return callApmApi('GET /internal/apm/environments', {
      params: {
        query: {
          start,
          end,
          serviceName
        }
      }
    });
  }, [start, end, serviceName]);
  return {
    environments: data.environments,
    status
  };
}