"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNonDataStreamIndices = getNonDataStreamIndices;
var _get_indices = require("./get_indices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getNonDataStreamIndices({
  esClient,
  apmIndices
}) {
  const apmIndexPatterns = (0, _get_indices.getApmIndexPatterns)([apmIndices.error, apmIndices.metric, apmIndices.span, apmIndices.transaction]);

  // TODO: indices already retrieved by `getIndicesAndIngestPipelines`
  const nonDataStreamIndicesResponse = await esClient.indices.get({
    index: apmIndexPatterns,
    filter_path: ['*.data_stream', '*.settings.index.uuid'],
    ignore_unavailable: true
  });
  const nonDataStreamIndices = Object.entries(nonDataStreamIndicesResponse).filter(([indexName, {
    data_stream: dataStream
  }]) => !dataStream).map(([indexName]) => indexName);
  return nonDataStreamIndices;
}