"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PathOptions = exports.OpenApiDetails = exports.GeneratedCelDetails = exports.CelInput = exports.CelDetails = exports.CelAuthTypeEnum = exports.CelAuthType = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Cel Input Attributes
 *   version: not applicable
 */

const PathOptions = exports.PathOptions = _zod.z.object({}).catchall(_zod.z.unknown());

/**
 * The type of auth utilized for the input.
 */

const CelAuthType = exports.CelAuthType = _zod.z.enum(['basic', 'digest', 'oauth2', 'header']);
const CelAuthTypeEnum = exports.CelAuthTypeEnum = CelAuthType.enum;

/**
 * Necessary OpenAPI spec details for building a CEL program.
 */

const OpenApiDetails = exports.OpenApiDetails = _zod.z.object({
  operation: _zod.z.string(),
  schemas: _zod.z.string(),
  auth: _zod.z.string().optional()
});

/**
 * Details for building a CEL program.
 */

const CelDetails = exports.CelDetails = _zod.z.object({
  path: _zod.z.string(),
  auth: CelAuthType,
  openApiDetails: OpenApiDetails.optional()
});

/**
 * Generated CEL details.
 */

const GeneratedCelDetails = exports.GeneratedCelDetails = _zod.z.object({
  configFields: _zod.z.object({}).catchall(_zod.z.unknown()),
  program: _zod.z.string(),
  needsAuthConfigBlock: _zod.z.boolean(),
  stateSettings: _zod.z.object({}).catchall(_zod.z.unknown()),
  redactVars: _zod.z.array(_zod.z.string())
});

/**
 * Optional CEL input details.
 */

const CelInput = exports.CelInput = _zod.z.object({
  authType: CelAuthType,
  configFields: _zod.z.object({}).catchall(_zod.z.unknown()),
  needsAuthConfigBlock: _zod.z.boolean(),
  program: _zod.z.string(),
  stateSettings: _zod.z.object({}).catchall(_zod.z.unknown()),
  redactVars: _zod.z.array(_zod.z.string()),
  url: _zod.z.string()
});