"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShapePreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _components = require("../../../canvas_plugin_src/renderers/shape/components");
var _shape_drawer = require("../shape_drawer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/canvas/public/components/shape_preview/shape_preview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getViewBox(defaultWidth, defaultViewBox) {
  const {
    minX,
    minY,
    width,
    height
  } = defaultViewBox;
  return {
    minX: minX - defaultWidth / 2,
    minY: minY - defaultWidth / 2,
    width: width + defaultWidth,
    height: height + defaultWidth
  };
}
const ShapePreview = ({
  shape
}) => {
  const [shapeData, setShapeData] = (0, _react.useState)((0, _shape_drawer.getDefaultShapeData)());
  const shapeRef = (0, _react.useCallback)(node => {
    if (node !== null) {
      setShapeData(node.getData());
    }
  }, []);
  if (!shape) return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasShapePreview",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 22
    }
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasShapePreview",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_components.ShapeDrawerComponent, {
    ref: shapeRef,
    shapeType: shape,
    shapeAttributes: {
      fill: 'none',
      stroke: 'black',
      viewBox: getViewBox(5, shapeData.viewBox)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }));
};
exports.ShapePreview = ShapePreview;
ShapePreview.propTypes = {
  shape: _propTypes.default.string
};