"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.zoomHandlerCreators = exports.useZoomHandlers = void 0;
var _react = require("react");
var _constants = require("../../common/lib/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// handlers for zooming in and out
const zoomHandlerCreators = exports.zoomHandlerCreators = {
  zoomIn: ({
    zoomScale,
    setZoomScale
  }) => () => {
    const scaleUp = _constants.ZOOM_LEVELS.find(zoomLevel => zoomScale < zoomLevel) || _constants.MAX_ZOOM_LEVEL;
    setZoomScale(scaleUp);
  },
  zoomOut: ({
    zoomScale,
    setZoomScale
  }) => () => {
    const scaleDown = _constants.ZOOM_LEVELS.slice().reverse().find(zoomLevel => zoomScale > zoomLevel) || _constants.MIN_ZOOM_LEVEL;
    setZoomScale(scaleDown);
  },
  resetZoom: ({
    setZoomScale
  }) => () => {
    setZoomScale(1);
  }
};
const useZoomHandlers = ({
  zoomScale,
  setZoomScale
}) => {
  const zoomIn = (0, _react.useCallback)(() => {
    const scaleUp = _constants.ZOOM_LEVELS.find(zoomLevel => zoomScale < zoomLevel) || _constants.MAX_ZOOM_LEVEL;
    setZoomScale(scaleUp);
  }, [zoomScale, setZoomScale]);
  const zoomOut = (0, _react.useCallback)(() => {
    const scaleDown = _constants.ZOOM_LEVELS.slice().reverse().find(zoomLevel => zoomScale > zoomLevel) || _constants.MIN_ZOOM_LEVEL;
    setZoomScale(scaleDown);
  }, [zoomScale, setZoomScale]);
  const resetZoom = (0, _react.useCallback)(() => {
    setZoomScale(1);
  }, [setZoomScale]);
  return {
    zoomIn,
    zoomOut,
    resetZoom
  };
};
exports.useZoomHandlers = useZoomHandlers;