"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "CANCEL", {
  enumerable: true,
  get: function () {
    return _translations.CANCEL;
  }
});
Object.defineProperty(exports, "EDITED_CASES", {
  enumerable: true,
  get: function () {
    return _translations2.EDITED_CASES;
  }
});
exports.NO_SELECTED_ASSIGNEES_HELP_TEXT = exports.NO_SELECTED_ASSIGNEES = exports.EDIT_ASSIGNEES = void 0;
Object.defineProperty(exports, "REMOVE_ASSIGNEES", {
  enumerable: true,
  get: function () {
    return _translations3.REMOVE_ASSIGNEES;
  }
});
Object.defineProperty(exports, "SAVE_SELECTION", {
  enumerable: true,
  get: function () {
    return _translations2.SAVE_SELECTION;
  }
});
exports.SELECTED_ASSIGNEES = exports.SEARCH_ASSIGNEES_PLACEHOLDER = void 0;
Object.defineProperty(exports, "SELECTED_CASES", {
  enumerable: true,
  get: function () {
    return _translations2.SELECTED_CASES;
  }
});
Object.defineProperty(exports, "UNKNOWN", {
  enumerable: true,
  get: function () {
    return _translations.UNKNOWN;
  }
});
var _i18n = require("@kbn/i18n");
var _translations = require("../../../common/translations");
var _translations2 = require("../translations");
var _translations3 = require("../../user_profiles/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EDIT_ASSIGNEES = exports.EDIT_ASSIGNEES = _i18n.i18n.translate('xpack.cases.actions.assignees.edit', {
  defaultMessage: 'Edit assignees'
});
const SELECTED_ASSIGNEES = selectedAssignees => _i18n.i18n.translate('xpack.cases.actions.assignees.selectedAssignees', {
  defaultMessage: 'Selected: {selectedAssignees}',
  values: {
    selectedAssignees
  }
});
exports.SELECTED_ASSIGNEES = SELECTED_ASSIGNEES;
const SEARCH_ASSIGNEES_PLACEHOLDER = exports.SEARCH_ASSIGNEES_PLACEHOLDER = _i18n.i18n.translate('xpack.cases.actions.assignees.searchPlaceholder', {
  defaultMessage: 'Find a user'
});
const NO_SELECTED_ASSIGNEES = totalCases => _i18n.i18n.translate('xpack.cases.actions.assignees.noSelectedAssigneesTitle', {
  values: {
    totalCases
  },
  defaultMessage: 'The selected {totalCases, plural, =1 {case does} other {cases do}} not have any assigned users'
});
exports.NO_SELECTED_ASSIGNEES = NO_SELECTED_ASSIGNEES;
const NO_SELECTED_ASSIGNEES_HELP_TEXT = exports.NO_SELECTED_ASSIGNEES_HELP_TEXT = _i18n.i18n.translate('xpack.cases.actions.assignees.noSelectedAssigneesHelpText', {
  defaultMessage: 'Search to assign users.'
});