"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFileUploadApi = useFileUploadApi;
var _react = require("react");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const canUpload = (files, uiState) => {
  return files.length && files[0].status !== 'uploaded' && uiState.phase === _types.UploadPhase.IDLE;
};
function useFileUploadApi(uploadState, uiState, dispatch) {
  (0, _react.useEffect)(() => {
    const subs = [uploadState.files$.subscribe(files => {
      if (canUpload(files, uiState)) {
        dispatch({
          type: _types.ActionType.START_UPLOAD,
          filename: files[0].file.name,
          placeholder: `<!-- uploading "${files[0].file.name}" -->`
        });
      }
    }), uploadState.done$.subscribe(files => {
      if (files !== null && files !== void 0 && files.length && uiState.phase === _types.UploadPhase.UPLOADING) {
        dispatch({
          type: _types.ActionType.UPLOAD_FINISHED,
          file: files[0],
          placeholder: uiState.placeholder
        });
      } else {
        dispatch({
          type: _types.ActionType.RESET
        });
      }
    }), uploadState.error$.subscribe(err => err && dispatch({
      type: _types.ActionType.UPLOAD_ERROR,
      errors: [err]
    }))];
    return () => subs.forEach(s => s.unsubscribe());
  }, [uploadState, uiState, dispatch]);
}