"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.builderMap = void 0;
var _assignees = require("./assignees");
var _comment = require("./comment/comment");
var _connector = require("./connector");
var _description = require("./description");
var _pushed = require("./pushed");
var _settings = require("./settings");
var _severity = require("./severity");
var _status = require("./status");
var _tags = require("./tags");
var _title = require("./title");
var _create_case = require("./create_case");
var _category = require("./category");
var _custom_fields = require("./custom_fields/custom_fields");
var _observables = require("./observables");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const builderMap = exports.builderMap = {
  create_case: _create_case.createCaseUserActionBuilder,
  connector: _connector.createConnectorUserActionBuilder,
  tags: _tags.createTagsUserActionBuilder,
  title: _title.createTitleUserActionBuilder,
  status: _status.createStatusUserActionBuilder,
  severity: _severity.createSeverityUserActionBuilder,
  pushed: _pushed.createPushedUserActionBuilder,
  comment: _comment.createCommentUserActionBuilder,
  description: _description.createDescriptionUserActionBuilder,
  settings: _settings.createSettingsUserActionBuilder,
  assignees: _assignees.createAssigneesUserActionBuilder,
  category: _category.createCategoryUserActionBuilder,
  customFields: _custom_fields.createCustomFieldsUserActionBuilder,
  observables: _observables.createObservablesUserActionBuilder
};