"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createExternalReferenceAttachmentUserActionBuilder = void 0;
var _registered_attachments = require("./registered_attachments");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createExternalReferenceAttachmentUserActionBuilder = ({
  userAction,
  userProfiles,
  attachment,
  externalReferenceAttachmentTypeRegistry,
  caseData,
  isLoading,
  handleDeleteComment
}) => {
  return (0, _registered_attachments.createRegisteredAttachmentUserActionBuilder)({
    userAction,
    userProfiles,
    attachment,
    registry: externalReferenceAttachmentTypeRegistry,
    caseData,
    handleDeleteComment,
    isLoading,
    getId: () => attachment.externalReferenceAttachmentTypeId,
    getAttachmentViewProps: () => ({
      externalReferenceId: attachment.externalReferenceId,
      externalReferenceMetadata: attachment.externalReferenceMetadata
    })
  });
};
exports.createExternalReferenceAttachmentUserActionBuilder = createExternalReferenceAttachmentUserActionBuilder;