"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeletePropertyAction = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDeletePropertyAction = ({
  onDelete
}) => {
  const [showDeletionModal, setShowDeletionModal] = (0, _react.useState)(false);
  const onModalOpen = (0, _react.useCallback)(() => {
    setShowDeletionModal(true);
  }, []);
  const onConfirm = (0, _react.useCallback)(() => {
    setShowDeletionModal(false);
    onDelete();
  }, [onDelete]);
  const onCancel = (0, _react.useCallback)(() => {
    setShowDeletionModal(false);
  }, []);
  return {
    showDeletionModal,
    onModalOpen,
    onConfirm,
    onCancel
  };
};
exports.useDeletePropertyAction = useDeletePropertyAction;