"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sourceIndexBySyncType = exports.destinationIndexBySyncType = exports.SYNCHRONIZATION_QUERIES_DICTIONARY = exports.CAI_REFRESH_INTERVAL = exports.CAI_NUMBER_OF_SHARDS = exports.CAI_INDEX_MODE = exports.CAI_DEFAULT_TIMEOUT = exports.CAI_AUTO_EXPAND_REPLICAS = exports.CAISyncTypes = void 0;
var _constants = require("./attachments_index/constants");
var _constants2 = require("./cases_index/constants");
var _constants3 = require("./comments_index/constants");
var _constants4 = require("./activity_index/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CAI_NUMBER_OF_SHARDS = exports.CAI_NUMBER_OF_SHARDS = 1;
/** Allocate 1 replica if there are enough data nodes, otherwise continue with 0 */
const CAI_AUTO_EXPAND_REPLICAS = exports.CAI_AUTO_EXPAND_REPLICAS = '0-1';
const CAI_REFRESH_INTERVAL = exports.CAI_REFRESH_INTERVAL = '15s';
const CAI_INDEX_MODE = exports.CAI_INDEX_MODE = 'lookup';
/**
 * When a request takes a long time to complete and hits the timeout or the
 * client aborts that request due to the requestTimeout, our only course of
 * action is to retry that request. This places our request at the end of the
 * queue and adds more load to Elasticsearch just making things worse.
 *
 * So we want to choose as long a timeout as possible. Some load balancers /
 * reverse proxies like ELB ignore TCP keep-alive packets so unless there's a
 * request or response sent over the socket it will be dropped after 60s.
 */
const CAI_DEFAULT_TIMEOUT = exports.CAI_DEFAULT_TIMEOUT = '300s';
const CAISyncTypes = exports.CAISyncTypes = [_constants2.CAI_CASES_SYNC_TYPE, _constants3.CAI_COMMENTS_SYNC_TYPE, _constants.CAI_ATTACHMENTS_SYNC_TYPE, _constants4.CAI_ACTIVITY_SYNC_TYPE];
const SYNCHRONIZATION_QUERIES_DICTIONARY = exports.SYNCHRONIZATION_QUERIES_DICTIONARY = {
  [_constants2.CAI_CASES_SYNC_TYPE]: _constants2.getCasesSynchronizationSourceQuery,
  [_constants3.CAI_COMMENTS_SYNC_TYPE]: _constants3.getCommentsSynchronizationSourceQuery,
  [_constants.CAI_ATTACHMENTS_SYNC_TYPE]: _constants.getAttachmentsSynchronizationSourceQuery,
  [_constants4.CAI_ACTIVITY_SYNC_TYPE]: _constants4.getActivitySynchronizationSourceQuery
};
const sourceIndexBySyncType = syncType => {
  switch (syncType) {
    case _constants2.CAI_CASES_SYNC_TYPE:
      return _constants2.CAI_CASES_SOURCE_INDEX;
    case _constants3.CAI_COMMENTS_SYNC_TYPE:
      return _constants3.CAI_COMMENTS_SOURCE_INDEX;
    case _constants.CAI_ATTACHMENTS_SYNC_TYPE:
      return _constants.CAI_ATTACHMENTS_SOURCE_INDEX;
    case _constants4.CAI_ACTIVITY_SYNC_TYPE:
      return _constants4.CAI_ACTIVITY_SOURCE_INDEX;
    default:
      throw new Error(`[sourceIndexBySyncType]: Unknown sync type: ${syncType}`);
  }
};
exports.sourceIndexBySyncType = sourceIndexBySyncType;
const destinationIndexBySyncType = (syncType, spaceId, owner) => {
  switch (syncType) {
    case _constants2.CAI_CASES_SYNC_TYPE:
      return (0, _constants2.getCasesDestinationIndexName)(spaceId, owner);
    case _constants3.CAI_COMMENTS_SYNC_TYPE:
      return (0, _constants3.getCommentsDestinationIndexName)(spaceId, owner);
    case _constants.CAI_ATTACHMENTS_SYNC_TYPE:
      return (0, _constants.getAttachmentsDestinationIndexName)(spaceId, owner);
    case _constants4.CAI_ACTIVITY_SYNC_TYPE:
      return (0, _constants4.getActivityDestinationIndexName)(spaceId, owner);
    default:
      throw new Error(`[destinationIndexBySyncType]: Unknown sync type: ${syncType}`);
  }
};
exports.destinationIndexBySyncType = destinationIndexBySyncType;