"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSynchronizationTaskId = getSynchronizationTaskId;
exports.registerCAISynchronizationTask = registerCAISynchronizationTask;
exports.scheduleCAISynchronizationTask = scheduleCAISynchronizationTask;
var _constants = require("../../../../common/constants");
var _synchronization_task_factory = require("./synchronization_task_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SCHEDULE = {
  interval: '5m'
};
function registerCAISynchronizationTask({
  taskManager,
  logger,
  core,
  analyticsConfig
}) {
  const getESClient = async () => {
    const [{
      elasticsearch
    }] = await core.getStartServices();
    return elasticsearch.client.asInternalUser;
  };
  taskManager.registerTaskDefinitions({
    [_constants.ANALYTICS_SYNCHRONIZATION_TASK_TYPE]: {
      title: 'Synchronization for the cases analytics index',
      createTaskRunner: context => {
        return new _synchronization_task_factory.AnalyticsIndexSynchronizationTaskFactory({
          getESClient,
          logger,
          analyticsConfig
        }).create(context);
      }
    }
  });
}
function getSynchronizationTaskId(spaceId, owner) {
  return `cai_cases_analytics_sync_${spaceId}_${owner}`;
}
async function scheduleCAISynchronizationTask({
  taskManager,
  logger,
  spaceId,
  owner
}) {
  const taskId = getSynchronizationTaskId(spaceId, owner);
  try {
    await taskManager.ensureScheduled({
      id: taskId,
      taskType: _constants.ANALYTICS_SYNCHRONIZATION_TASK_TYPE,
      params: {
        owner,
        spaceId
      },
      schedule: SCHEDULE,
      // every 5 minutes
      state: {}
    });
  } catch (e) {
    logger.error(`Error scheduling ${taskId} task, received ${e.message}`);
  }
}