"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processCase = exports.isStringOrArray = exports.findCasesContainingAllAlertsRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _pLimit = _interopRequireDefault(require("p-limit"));
var _create_cases_route = require("../create_cases_route");
var _constants = require("../../../../common/constants");
var _constants2 = require("../constants");
var _utils = require("../../../client/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// cases modal shows 10 cases by default
const MAX_CONCURRENT_CASES = 10;
const findCasesContainingAllAlertsRoute = exports.findCasesContainingAllAlertsRoute = (0, _create_cases_route.createCasesRoute)({
  method: 'post',
  path: _constants.INTERNAL_CASE_GET_CASES_BY_ATTACHMENT_URL,
  security: _constants2.DEFAULT_CASES_ROUTE_SECURITY,
  params: {
    body: _configSchema.schema.object({
      alertIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
      caseIds: _configSchema.schema.arrayOf(_configSchema.schema.string())
    })
  },
  routerOptions: {
    access: 'internal'
  },
  handler: async ({
    context,
    request,
    response
  }) => {
    const {
      alertIds,
      caseIds
    } = request.body;
    if (!caseIds.length || !alertIds.length) {
      return response.ok({
        body: {
          casesWithAllAttachments: []
        }
      });
    }
    const caseIdsToCheck = Array.isArray(caseIds) ? caseIds : [caseIds];
    const alertIdSet = new Set(alertIds);
    const casesContext = await context.cases;
    const casesClient = await casesContext.getCasesClient();
    const limit = (0, _pLimit.default)(MAX_CONCURRENT_CASES);
    const results = await Promise.all(caseIdsToCheck.map(caseId => {
      return limit(async () => processCase(casesClient, caseId, alertIdSet));
    }));
    return response.ok({
      body: {
        casesWithAllAttachments: results.filter(id => id !== null)
      }
    });
  }
});
const isStringOrArray = value => {
  return typeof value === 'string' || Array.isArray(value) && value.every(item => typeof item === 'string');
};
exports.isStringOrArray = isStringOrArray;
const processCase = async (casesClient, caseId, alertIds) => {
  const alertsForCase = await casesClient.attachments.getAllAlertsAttachToCase({
    caseId,
    filter: (0, _utils.buildFilter)({
      filters: Array.from(alertIds),
      field: 'alertId',
      operator: 'or',
      type: 'cases-comments'
    })
  });
  return alertIds.size === alertsForCase.length ? caseId : null;
};
exports.processCase = processCase;