"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.decreaseOpacity = decreaseOpacity;
var _chromaJs = _interopRequireDefault(require("chroma-js"));
var _uiTheme = require("@kbn/ui-theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const MIN_OPACITY = 0.2;

/**
 * Reduces color opacity, by mixing color with background color.
 *
 * This is used when the resulting color needs to be opaque (i.e. alpha of 1).
 */
function decreaseOpacity(baseColor, step, totalSteps) {
  if (totalSteps === 1) {
    return baseColor;
  }
  const backgroundColor = _uiTheme.euiThemeVars.euiColorEmptyShade;
  const ratio = Math.min(0.2 * (step - 1), 1 - MIN_OPACITY);
  const color = (0, _chromaJs.default)(baseColor).mix(backgroundColor, ratio, 'lch');
  return color.hex().toUpperCase();
}