"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertsStats = void 0;
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAlertsStatsQuery = index => ({
  size: 0,
  query: {
    bool: {
      filter: [{
        term: {
          'kibana.alert.rule.tags': 'Cloud Security'
        }
      }]
    }
  },
  sort: '@timestamp:desc',
  index,
  aggs: {
    cspm: {
      filter: {
        term: {
          'kibana.alert.rule.tags': 'CSPM'
        }
      },
      aggs: {
        rules_count: {
          cardinality: {
            field: 'kibana.alert.rule.uuid'
          }
        },
        alerts_open: {
          filter: {
            term: {
              'kibana.alert.workflow_status': 'open'
            }
          }
        },
        alerts_acknowledged: {
          filter: {
            term: {
              'kibana.alert.workflow_status': 'acknowledged'
            }
          }
        },
        alerts_closed: {
          filter: {
            term: {
              'kibana.alert.workflow_status': 'closed'
            }
          }
        }
      }
    },
    kspm: {
      filter: {
        term: {
          'kibana.alert.rule.tags': 'KSPM'
        }
      },
      aggs: {
        rules_count: {
          cardinality: {
            field: 'kibana.alert.rule.uuid'
          }
        },
        alerts_open: {
          filter: {
            term: {
              'kibana.alert.workflow_status': 'open'
            }
          }
        },
        alerts_acknowledged: {
          filter: {
            term: {
              'kibana.alert.workflow_status': 'acknowledged'
            }
          }
        },
        alerts_closed: {
          filter: {
            term: {
              'kibana.alert.workflow_status': 'closed'
            }
          }
        }
      }
    },
    vuln_mgmt: {
      filter: {
        term: {
          'kibana.alert.rule.tags': 'CNVM'
        }
      },
      aggs: {
        rules_count: {
          cardinality: {
            field: 'kibana.alert.rule.uuid'
          }
        },
        alerts_open: {
          filter: {
            term: {
              'kibana.alert.workflow_status': 'open'
            }
          }
        },
        alerts_acknowledged: {
          filter: {
            term: {
              'kibana.alert.workflow_status': 'acknowledged'
            }
          }
        },
        alerts_closed: {
          filter: {
            term: {
              'kibana.alert.workflow_status': 'closed'
            }
          }
        }
      }
    }
  }
});
const getAlertsStats = async (esClient, logger) => {
  const index = _constants.DETECTION_ENGINE_ALERTS_INDEX_DEFAULT;
  try {
    const isIndexExists = await esClient.indices.exists({
      index
    });
    if (isIndexExists) {
      const alertsStats = await esClient.search(getAlertsStatsQuery(index));
      const postureTypes = ['cspm', 'kspm', 'vuln_mgmt'];
      return postureTypes.filter(postureType => {
        var _alertsStats$aggregat, _alertsStats$aggregat2;
        return (alertsStats === null || alertsStats === void 0 ? void 0 : (_alertsStats$aggregat = alertsStats.aggregations) === null || _alertsStats$aggregat === void 0 ? void 0 : (_alertsStats$aggregat2 = _alertsStats$aggregat[postureType]) === null || _alertsStats$aggregat2 === void 0 ? void 0 : _alertsStats$aggregat2.doc_count) && alertsStats.aggregations[postureType].doc_count > 0;
      }).map(postureType => {
        var _postureTypeData$rule, _postureTypeData$aler, _postureTypeData$aler2, _postureTypeData$aler3;
        const postureTypeData = alertsStats.aggregations[postureType];
        return {
          posture_type: postureType,
          rules_count: (_postureTypeData$rule = postureTypeData.rules_count) === null || _postureTypeData$rule === void 0 ? void 0 : _postureTypeData$rule.value,
          alerts_count: postureTypeData.doc_count,
          alerts_open_count: (_postureTypeData$aler = postureTypeData.alerts_open) === null || _postureTypeData$aler === void 0 ? void 0 : _postureTypeData$aler.doc_count,
          alerts_acknowledged_count: (_postureTypeData$aler2 = postureTypeData.alerts_acknowledged) === null || _postureTypeData$aler2 === void 0 ? void 0 : _postureTypeData$aler2.doc_count,
          alerts_closed_count: (_postureTypeData$aler3 = postureTypeData.alerts_closed) === null || _postureTypeData$aler3 === void 0 ? void 0 : _postureTypeData$aler3.doc_count
        };
      });
    }
    return [];
  } catch (e) {
    logger.error(`Failed to get index stats for ${index}: ${e}`);
    return [];
  }
};
exports.getAlertsStats = getAlertsStats;