"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
var _coreChromeLayoutConstants = require("@kbn/core-chrome-layout-constants");
var _styles = require("./styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const useStyles = () => {
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const {
    euiTheme
  } = euiThemeContext;
  const variables = (0, _styles.useEmbeddableConsoleStyleVariables)();
  return {
    embeddableConsoleGlobal: (0, _react.css)`
      .kbnBody--hasEmbeddableConsole .euiPageTemplate main {
        // Ensure page content is not overlapped by console control bar
        padding-bottom: ${euiTheme.size.xxl};
      }
    `,
    embeddableConsole: (0, _react.css)`
      background: ${variables.background};
      color: ${variables.text};
      display: flex;
      flex-direction: column;
      // This large box shadow helps prevent a flicker of dark
      // background when the content is shown and hidden
      box-shadow: inset 0 ${variables.initialHeight} 0 ${variables.background},
        inset 0 600rem 0 ${euiTheme.colors.body};
      bottom: ${(0, _coreChromeLayoutConstants.layoutVar)('application.content.bottom', '0px')};
      right: ${(0, _coreChromeLayoutConstants.layoutVar)('application.content.right', '0px')};
      transform: translateY(0);
      height: ${variables.initialHeight};
      max-height: ${variables.maxHeight};

      ${(0, _eui.useEuiBreakpoint)(['xs', 's'])} {
        display: none;
      }
    `,
    embeddableConsoleOpen: (0, _react.css)`
      animation-duration: ${euiTheme.animation.normal};
      animation-timing-function: ${euiTheme.animation.resistance};
      animation-fill-mode: forwards;
      animation-name: embeddableConsoleOpenPanel;
      height: var(--embedded-console-height);
      bottom: calc(
        var(--embedded-console-bottom) + ${(0, _coreChromeLayoutConstants.layoutVar)('application.content.bottom', '0px')}
      );

      @keyframes embeddableConsoleOpenPanel {
        0% {
          transform: translateY(-${variables.initialHeight});
        }

        100% {
          transform: translateY(var(--embedded-console-bottom));
        }
      }
    `,
    embeddableConsoleChromeProject: (0, _react.css)`
      left: calc(
        var(--euiCollapsibleNavOffset, 0) + ${(0, _coreChromeLayoutConstants.layoutVar)('application.content.left', '0px')}
      );
    `,
    embeddableConsoleChromeClassic: (0, _react.css)`
      left: calc(var(--kbnSolutionNavOffset, 0) + ${(0, _coreChromeLayoutConstants.layoutVar)('application.content.left', '0px')});
    `,
    embeddableConsoleChromeDefault: (0, _react.css)`
      left: ${(0, _coreChromeLayoutConstants.layoutVar)('application.content.left', '0px')};
    `,
    embeddableConsoleFixed: (0, _react.css)`
      position: fixed;
      z-index: calc(${euiTheme.levels.header} - 2);
    `,
    embeddableConsoleControls: (0, _react.css)`
      height: ${variables.initialHeight};
      width: 100%;
      display: flex;
      justify-content: flex-start;
      align-items: center;
      overflow-y: hidden; // Ensures the movement of buttons in :focus don't cause scrollbars
      overflow-x: auto;
      padding-right: ${euiTheme.size.s};
    `,
    embeddableConsoleControlsButton: (0, _react.css)`
      flex-grow: 1;
      width: 100%;

      .euiButtonEmpty__content {
        justify-content: flex-start;
      }
    `,
    embeddableControlsAltViewButtonContainer: (0, _react.css)`
      margin-left: auto;
    `,
    embeddableConsoleContent: (0, _styles.useEmbeddableConsoleContentStyles)()
  };
};
exports.useStyles = useStyles;