"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertConnector = exports.ConvertConnectorApiLogic = void 0;
var _create_api_logic = require("../api_logic/create_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertConnector = async ({
  connectorId,
  http
}) => {
  const route = `/internal/content_connectors/connectors/${connectorId}/native`;
  return await (http === null || http === void 0 ? void 0 : http.put(route, {
    body: JSON.stringify({
      is_native: false
    })
  }));
};
exports.convertConnector = convertConnector;
const ConvertConnectorApiLogic = exports.ConvertConnectorApiLogic = (0, _create_api_logic.createApiLogic)(['convert_connector_api_logic'], convertConnector);