"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RpcService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class RpcService {
  constructor() {
    (0, _defineProperty2.default)(this, "registry", new Map());
  }
  register(name, definition) {
    this.registry.set(name, definition);
  }
  async call(context, name, input) {
    const procedure = this.registry.get(name);
    if (!procedure) throw new Error(`Procedure [${name}] is not registered.`);
    const {
      fn,
      schemas
    } = procedure;

    // 1. Validate input
    if (schemas !== null && schemas !== void 0 && schemas.in) {
      const error = (0, _utils.validate)(input, schemas.in);
      if (error) {
        // TODO: Improve error handling
        throw error;
      }
    } else if (input !== undefined) {
      // TODO: Improve error handling
      throw new Error(`Input schema missing for [${name}] procedure.`);
    }

    // 2. Execute procedure
    const result = await fn(context, input);

    // 3. Validate output
    if (schemas !== null && schemas !== void 0 && schemas.out) {
      const error = (0, _utils.validate)(result, schemas.out);
      if (error) {
        // TODO: Improve error handling
        throw error;
      }
    }
    return {
      result
    };
  }
}
exports.RpcService = RpcService;