"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeControlGroupUnsavedChanges = initializeControlGroupUnsavedChanges;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _rxjs = require("rxjs");
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _publishes_async_filters = require("../controls/data_controls/publishes_async_filters");
var _init_controls_manager = require("./init_controls_manager");
var _serialization_utils = require("./utils/serialization_utils");
var _initialize_editor_state_manager = require("./initialize_editor_state_manager");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function initializeControlGroupUnsavedChanges({
  applySelections,
  children$,
  controlGroupId,
  editorStateManager,
  layout$,
  parentApi,
  resetControlsUnsavedChanges,
  serializeControlGroupState
}) {
  function getLastSavedControlsState() {
    if (!(0, _presentationContainers.apiHasLastSavedChildState)(parentApi)) {
      return {};
    }
    const lastSavedControlGroupState = parentApi.getLastSavedStateForChild(controlGroupId);
    return lastSavedControlGroupState ? (0, _serialization_utils.deserializeControlGroup)(lastSavedControlGroupState).initialChildControlState : {};
  }
  function getLastSavedStateForControl(controlId) {
    const controlState = getLastSavedControlsState()[controlId];
    return controlState ? {
      rawState: controlState
    } : undefined;
  }
  const lastSavedControlsState$ = (0, _presentationContainers.apiHasLastSavedChildState)(parentApi) ? parentApi.lastSavedStateForChild$(controlGroupId).pipe((0, _rxjs.map)(() => getLastSavedControlsState())) : (0, _rxjs.of)({});
  const controlGroupEditorUnsavedChangesApi = (0, _presentationContainers.initializeUnsavedChanges)({
    uuid: controlGroupId,
    parentApi,
    serializeState: serializeControlGroupState,
    anyStateChange$: (0, _rxjs.merge)(editorStateManager.anyStateChange$),
    getComparators: () => _initialize_editor_state_manager.editorStateComparators,
    defaultState: _initialize_editor_state_manager.defaultEditorState,
    onReset: lastSaved => {
      editorStateManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
    }
  });
  const hasLayoutChanges$ = layout$.pipe((0, _rxjs.combineLatestWith)(lastSavedControlsState$.pipe((0, _rxjs.map)(controlsState => (0, _init_controls_manager.getControlsInOrder)(controlsState)))), (0, _rxjs.debounceTime)(100), (0, _rxjs.map)(([, lastSavedLayout]) => {
    const currentLayout = layout$.value;
    return !(0, _fastDeepEqual.default)(currentLayout, lastSavedLayout);
  }));
  const hasControlChanges$ = (0, _presentationContainers.childrenUnsavedChanges$)(children$).pipe((0, _rxjs.map)(childrenWithChanges => {
    return childrenWithChanges.some(({
      hasUnsavedChanges
    }) => hasUnsavedChanges);
  }));
  return {
    api: {
      lastSavedStateForChild$: controlId => lastSavedControlsState$.pipe((0, _rxjs.map)(() => getLastSavedStateForControl(controlId))),
      getLastSavedStateForChild: getLastSavedStateForControl,
      hasUnsavedChanges$: (0, _rxjs.combineLatest)([controlGroupEditorUnsavedChangesApi.hasUnsavedChanges$, hasControlChanges$, hasLayoutChanges$]).pipe((0, _rxjs.map)(([hasUnsavedControlGroupChanges, hasControlChanges, hasLayoutChanges]) => {
        return hasUnsavedControlGroupChanges || hasControlChanges || hasLayoutChanges;
      })),
      resetUnsavedChanges: async () => {
        controlGroupEditorUnsavedChangesApi.resetUnsavedChanges();
        resetControlsUnsavedChanges(getLastSavedControlsState());
        const filtersReadyPromises = [];
        Object.values(children$.value).forEach(controlApi => {
          if ((0, _presentationPublishing.apiPublishesUnsavedChanges)(controlApi)) controlApi.resetUnsavedChanges();
          if ((0, _publishes_async_filters.apiPublishesAsyncFilters)(controlApi)) {
            filtersReadyPromises.push(controlApi.untilFiltersReady());
          }
        });
        await Promise.all(filtersReadyPromises);
        if (!editorStateManager.api.autoApplySelections$.value) {
          applySelections();
        }
      }
    }
  };
}