"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deserializeControlGroup = void 0;
var _uuid = require("uuid");
var _reference_name_utils = require("../../controls/data_controls/reference_name_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const deserializeControlGroup = state => {
  var _state$rawState$contr, _state$references;
  const initialChildControlState = {};
  ((_state$rawState$contr = state.rawState.controls) !== null && _state$rawState$contr !== void 0 ? _state$rawState$contr : []).forEach(controlSeriailizedState => {
    const {
      controlConfig,
      id,
      ...rest
    } = controlSeriailizedState;
    initialChildControlState[id !== null && id !== void 0 ? id : (0, _uuid.v4)()] = {
      ...rest,
      ...(controlConfig !== null && controlConfig !== void 0 ? controlConfig : {})
    };
  });

  // Inject data view references into each individual control
  // TODO move reference injection into control factory to avoid leaking implemenation details like dataViewId to ControlGroup
  const references = (_state$references = state.references) !== null && _state$references !== void 0 ? _state$references : [];
  references.forEach(reference => {
    const referenceName = reference.name;
    const {
      controlId
    } = (0, _reference_name_utils.parseReferenceName)(referenceName);
    if (initialChildControlState[controlId]) {
      initialChildControlState[controlId].dataViewId = reference.id;
    }
  });
  return {
    ...state.rawState,
    initialChildControlState
  };
};
exports.deserializeControlGroup = deserializeControlGroup;