"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildTypesMappings = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Merge mappings from all registered saved object types.
 */
const buildTypesMappings = types => {
  return types.reduce((acc, {
    name: type,
    mappings
  }) => {
    const duplicate = Object.hasOwn(acc, type);
    if (duplicate) {
      throw new Error(`Type ${type} is already defined.`);
    }
    acc[type] = mappings;
    return acc;
  }, {});
};
exports.buildTypesMappings = buildTypesMappings;