"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAliasActions = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Build the list of alias actions to perform, depending on the current state of the cluster.
 */
const getAliasActions = ({
  indexPrefix,
  currentIndex,
  existingAliases,
  kibanaVersion
}) => {
  const actions = [];
  const globalAlias = indexPrefix;
  const versionAlias = `${indexPrefix}_${kibanaVersion}`;
  const allAliases = [globalAlias, versionAlias];
  allAliases.forEach(alias => {
    if (!existingAliases.includes(alias)) {
      actions.push({
        add: {
          index: currentIndex,
          alias
        }
      });
    }
  });
  return actions;
};
exports.getAliasActions = getAliasActions;