"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NavLinksService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _to_nav_link = require("./to_nav_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class NavLinksService {
  constructor() {
    (0, _defineProperty2.default)(this, "stop$", new _rxjs.ReplaySubject(1));
  }
  start({
    application,
    http
  }) {
    const navLinks$ = new _rxjs.BehaviorSubject(new Map());
    application.applications$.pipe((0, _rxjs.map)(apps => {
      return new Map([...apps].filter(([, app]) => !app.chromeless).reduce((navLinks, [appId, app]) => {
        const navLink = (0, _to_nav_link.toNavLink)(app, http.basePath);
        if (navLink) {
          navLinks.push([appId, navLink]);
        }
        navLinks.push(...toNavDeepLinks(app, app.deepLinks, http.basePath));
        return navLinks;
      }, []));
    })).subscribe(navlinks => {
      navLinks$.next(navlinks);
    });
    const forceAppSwitcherNavigation$ = new _rxjs.BehaviorSubject(false);
    return {
      getNavLinks$: () => {
        return navLinks$.pipe((0, _rxjs.map)(sortNavLinks), (0, _rxjs.takeUntil)(this.stop$));
      },
      get(id) {
        const link = navLinks$.value.get(id);
        return link && link.properties;
      },
      getAll() {
        return sortNavLinks(navLinks$.value);
      },
      has(id) {
        return navLinks$.value.has(id);
      },
      enableForcedAppSwitcherNavigation() {
        forceAppSwitcherNavigation$.next(true);
      },
      getForceAppSwitcherNavigation$() {
        return forceAppSwitcherNavigation$.asObservable();
      }
    };
  }
  stop() {
    this.stop$.next();
  }
}
exports.NavLinksService = NavLinksService;
function sortNavLinks(navLinks) {
  return (0, _lodash.sortBy)([...navLinks.values()].map(link => link.properties), 'order');
}
function toNavDeepLinks(app, deepLinks, basePath) {
  if (!deepLinks) {
    return [];
  }
  return deepLinks.reduce((navDeepLinks, deepLink) => {
    const id = `${app.id}:${deepLink.id}`;
    if (deepLink.path) {
      const navDeepLink = (0, _to_nav_link.toNavLink)(app, basePath, {
        ...deepLink,
        id
      });
      if (navDeepLink) {
        navDeepLinks.push([id, navDeepLink]);
      }
    }
    navDeepLinks.push(...toNavDeepLinks(app, deepLink.deepLinks, basePath));
    return navDeepLinks;
  }, []);
}