"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MenuItem = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _use_high_contrast_mode_styles = require("../../hooks/use_high_contrast_mode_styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/core/packages/chrome/navigation/src/components/menu_item/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MenuItem = exports.MenuItem = /*#__PURE__*/(0, _react.forwardRef)(({
  as = 'a',
  children,
  href,
  iconSize = 's',
  iconType,
  id,
  isCurrent = false,
  isHighlighted,
  isHorizontal,
  isLabelVisible = true,
  isTruncated = true,
  ...props
}, ref) => {
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const {
    euiTheme
  } = euiThemeContext;
  const isSingleWord = typeof children === 'string' && !children.includes(' ');
  const buttonStyles = (0, _react2.css)`
      --menu-item-text-color: ${isHighlighted ? euiTheme.components.buttons.textColorPrimary : euiTheme.components.buttons.textColorText};
      --high-contrast-hover-indicator-color: var(--menu-item-text-color);
      ${(0, _use_high_contrast_mode_styles.useHighContrastModeStyles)('.iconWrapper')};

      width: 100%;
      position: relative;
      overflow: hidden;
      align-items: center;
      justify-content: ${isHorizontal ? 'initial' : 'center'};
      display: flex;
      flex-direction: ${isHorizontal ? 'row' : 'column'};
      // 3px is from Figma; there is no token
      gap: ${isHorizontal ? euiTheme.size.s : '3px'};
      color: var(--menu-item-text-color);
      // Focus affordance with border on the iconWrapper instead
      outline: none !important;

      .iconWrapper {
        position: relative;
        display: flex;
        justify-content: center;
        align-items: center;
        height: ${euiTheme.size.xl};
        width: ${euiTheme.size.xl};
        border-radius: ${euiTheme.border.radius.medium};
        background-color: ${isHighlighted ? euiTheme.components.buttons.backgroundPrimary : isHorizontal ? euiTheme.colors.backgroundBaseSubdued : euiTheme.components.buttons.backgroundText};
        z-index: 1;
      }

      .iconWrapper::before {
        content: '';
        position: absolute;
        inset: 0;
        border-radius: ${euiTheme.border.radius.medium};
        background-color: transparent;
        z-index: 0;
      }

      // TODO: consider using euiFocusRing
      // source: https://developer.mozilla.org/en-US/docs/Web/CSS/:focus-visible
      &:focus-visible .iconWrapper {
        border: ${euiTheme.border.width.thick} solid
          ${isHighlighted ? euiTheme.colors.textPrimary : euiTheme.colors.textParagraph};
      }

      &:hover .iconWrapper::before {
        background-color: ${isHighlighted ? euiTheme.components.buttons.backgroundPrimaryHover : euiTheme.components.buttons.backgroundTextHover};
      }

      &:active .iconWrapper::before {
        background-color: ${isHighlighted ? euiTheme.components.buttons.backgroundPrimaryActive : euiTheme.components.buttons.backgroundTextActive};
      }
    `;
  const truncatedStyles = isTruncated && (isSingleWord ? (0, _react2.css)`
            /* Single word: stay on one line, truncate with ellipsis */
            white-space: nowrap;
            text-overflow: ellipsis;
          ` : (0, _react2.css)`
            /* Multiple words: allow wrapping to 2 lines */
            display: -webkit-box;
            -webkit-box-orient: vertical;
            line-clamp: 2;
            -webkit-line-clamp: 2;
          `);
  const verticalStyles = (0, _react2.css)`
      ${(0, _eui.euiFontSize)(euiThemeContext, 'xxs', {
    unit: 'px'
  }).fontSize};
      font-weight: ${euiTheme.font.weight.semiBold};
    `;
  const horizontalStyles = (0, _react2.css)`
      font-weight: ${isHighlighted ? euiTheme.font.weight.semiBold : euiTheme.font.weight.regular};
    `;
  const labelStyles = (0, _react2.css)`
      ${truncatedStyles}
      ${isHorizontal ? horizontalStyles : verticalStyles}
      overflow: hidden;
      max-width: 100%;
      padding: 0 ${euiTheme.size.s};
    `;
  const content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "iconWrapper",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "aria-hidden": true,
      color: "currentColor",
      type: "empty",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 31
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    "aria-hidden": true,
    color: "currentColor",
    type: iconType || 'empty',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  }))), isLabelVisible ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: isHorizontal ? 's' : 'xs',
    textAlign: "center",
    css: labelStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 11
    }
  }, children) : /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 13
    }
  }, children)));
  const commonProps = {
    css: buttonStyles,
    'data-menu-item': true,
    'data-highlighted': isHighlighted ? 'true' : 'false',
    ...props
  };
  if (as === 'button') {
    return /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({
      id: id,
      ref: ref
    }, commonProps, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 9
      }
    }), content);
  }
  return /*#__PURE__*/_react.default.createElement("a", (0, _extends2.default)({
    "aria-current": isCurrent ? 'page' : undefined,
    href: href,
    id: id,
    ref: ref
  }, commonProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 7
    }
  }), content);
});