"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLayoutWidth = exports.SIDE_PANEL_WIDTH = exports.EXPANDED_WIDTH = exports.COLLAPSED_WIDTH = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const COLLAPSED_WIDTH = exports.COLLAPSED_WIDTH = 48;
const EXPANDED_WIDTH = exports.EXPANDED_WIDTH = 100;
const SIDE_PANEL_WIDTH = exports.SIDE_PANEL_WIDTH = 240;
/**
 * Hook for handling layout width changes.
 *
 * @param isCollapsed - Whether the side nav is collapsed.
 * @param isSidePanelOpen - Whether the side panel is open.
 * @param setWidth - Callback to set the width of the navigation component.
 */
const useLayoutWidth = ({
  isCollapsed,
  isSidePanelOpen,
  setWidth
}) => {
  (0, _react.useEffect)(() => {
    setWidth(isCollapsed ? COLLAPSED_WIDTH : EXPANDED_WIDTH);
    if (isSidePanelOpen) {
      setWidth(isCollapsed ? COLLAPSED_WIDTH + SIDE_PANEL_WIDTH : EXPANDED_WIDTH + SIDE_PANEL_WIDTH);
    }
  }, [isCollapsed, isSidePanelOpen, setWidth]);
};
exports.useLayoutWidth = useLayoutWidth;