"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupServer = void 0;
var _coreExecutionContextServerMocks = require("@kbn/core-execution-context-server-mocks");
var _coreHttpContextServerInternal = require("@kbn/core-http-context-server-internal");
var _coreHttpServerInternal = require("@kbn/core-http-server-internal");
var _coreHttpServerMocks = require("@kbn/core-http-server-mocks");
var _coreHttpContextServerMocks = require("@kbn/core-http-context-server-mocks");
var _coreSavedObjectsApiServerMocks = require("@kbn/core-saved-objects-api-server-mocks");
var _coreSavedObjectsBaseServerMocks = require("@kbn/core-saved-objects-base-server-mocks");
var _coreSavedObjectsServerMocks = require("@kbn/core-saved-objects-server-mocks");
var _coreElasticsearchServerMocks = require("@kbn/core-elasticsearch-server-mocks");
var _coreUiSettingsServerMocks = require("@kbn/core-ui-settings-server-mocks");
var _coreDeprecationsServerMocks = require("@kbn/core-deprecations-server-mocks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const defaultCoreId = Symbol('core');
function createCoreServerRequestHandlerContextMock() {
  return {
    savedObjects: {
      client: _coreSavedObjectsApiServerMocks.savedObjectsClientMock.create(),
      typeRegistry: _coreSavedObjectsBaseServerMocks.typeRegistryMock.create(),
      getClient: _coreSavedObjectsApiServerMocks.savedObjectsClientMock.create,
      getExporter: _coreSavedObjectsServerMocks.savedObjectsServiceMock.createExporter,
      getImporter: _coreSavedObjectsServerMocks.savedObjectsServiceMock.createImporter
    },
    elasticsearch: {
      client: _coreElasticsearchServerMocks.elasticsearchServiceMock.createScopedClusterClient()
    },
    uiSettings: {
      client: _coreUiSettingsServerMocks.uiSettingsServiceMock.createClient()
    },
    deprecations: {
      client: _coreDeprecationsServerMocks.deprecationsServiceMock.createClient()
    }
  };
}
const setupServer = async (coreId = defaultCoreId) => {
  const coreContext = (0, _coreHttpServerMocks.createCoreContext)({
    coreId
  });
  const contextService = new _coreHttpContextServerInternal.ContextService(coreContext);
  const server = new _coreHttpServerInternal.HttpService(coreContext);
  await server.preboot({
    context: _coreHttpContextServerMocks.contextServiceMock.createPrebootContract()
  });
  const httpSetup = await server.setup({
    context: contextService.setup({
      pluginDependencies: new Map()
    }),
    executionContext: _coreExecutionContextServerMocks.executionContextServiceMock.createInternalSetupContract()
  });
  const handlerContext = createCoreServerRequestHandlerContextMock();
  httpSetup.registerRouteHandlerContext(coreId, 'core', (ctx, req, res) => {
    return handlerContext;
  });
  return {
    server: {
      listener: httpSetup.server.listener,
      start: async () => {
        await server.start();
      },
      stop: async () => {
        await server.stop();
      }
    },
    createRouter: httpSetup.createRouter.bind(httpSetup),
    registerRouteHandlerContext: httpSetup.registerRouteHandlerContext.bind(httpSetup),
    handlerContext
  };
};
exports.setupServer = setupServer;