"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardApp = DashboardApp;
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _uuid = require("uuid");
var _constants = require("../../common/constants");
var _dashboard_renderer = require("../dashboard_renderer/dashboard_renderer");
var _dashboard_top_nav = require("../dashboard_top_nav");
var _kibana_services = require("../services/kibana_services");
var _urls = require("../utils/urls");
var _dashboard_mount_context = require("./hooks/dashboard_mount_context");
var _use_dashboard_outcome_validation = require("./hooks/use_dashboard_outcome_validation");
var _use_observability_ai_assistant_context = require("./hooks/use_observability_ai_assistant_context");
var _dashboard_app_no_data = require("./no_data/dashboard_app_no_data");
var _dashboard_tab_title_setter = require("./tab_title_setter/dashboard_tab_title_setter");
var _search_sessions_integration = require("./url/search_sessions_integration");
var _url = require("./url");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/dashboard/public/dashboard_app/dashboard_app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DashboardApp({
  savedDashboardId,
  embedSettings,
  redirectTo,
  history,
  expandedPanelId
}) {
  const [showNoDataPage, setShowNoDataPage] = (0, _react.useState)(false);
  const [regenerateId, setRegenerateId] = (0, _react.useState)((0, _uuid.v4)());
  const incomingEmbeddable = (0, _react.useMemo)(() => {
    return _kibana_services.embeddableService.getStateTransfer().getIncomingEmbeddablePackage(_constants.DASHBOARD_APP_ID, true);
  }, []);
  (0, _react.useEffect)(() => {
    let canceled = false;
    // show dashboard when there is an incoming embeddable
    if (incomingEmbeddable) {
      return;
    }
    (0, _dashboard_app_no_data.isDashboardAppInNoDataState)().then(isInNotDataState => {
      if (!canceled && isInNotDataState) {
        setShowNoDataPage(true);
      }
    }).catch(error => {
      // show dashboard application if inNoDataState can not be determined
    });
    return () => {
      canceled = true;
    };
  }, [incomingEmbeddable]);
  const [dashboardApi, setDashboardApi] = (0, _react.useState)(undefined);
  const showPlainSpinner = (0, _useObservable.default)(_kibana_services.coreServices.customBranding.hasCustomBranding$, false);
  const {
    scopedHistory: getScopedHistory
  } = (0, _dashboard_mount_context.useDashboardMountContext)();
  (0, _use_observability_ai_assistant_context.useObservabilityAIAssistantContext)({
    dashboardApi
  });
  (0, _public.useExecutionContext)(_kibana_services.coreServices.executionContext, {
    type: 'application',
    page: 'app',
    id: savedDashboardId || 'new'
  });
  const kbnUrlStateStorage = (0, _react.useMemo)(() => (0, _public2.createKbnUrlStateStorage)({
    history,
    useHash: _kibana_services.coreServices.uiSettings.get('state:storeInSessionStorage'),
    ...(0, _public2.withNotifyOnErrors)(_kibana_services.coreServices.notifications.toasts)
  }), [history]);

  /**
   * Clear search session when leaving dashboard route
   */
  (0, _react.useEffect)(() => {
    return () => {
      _kibana_services.dataService.search.session.clear();
    };
  }, []);

  /**
   * Validate saved object load outcome
   */
  const {
    validateOutcome,
    getLegacyConflictWarning
  } = (0, _use_dashboard_outcome_validation.useDashboardOutcomeValidation)();

  /**
   * Create options to pass into the dashboard renderer
   */
  const getCreationOptions = (0, _react.useCallback)(() => {
    var _kbnUrlStateStorage$g, _kbnUrlStateStorage$g2;
    const searchSessionIdFromURL = (0, _search_sessions_integration.getSearchSessionIdFromURL)(history);
    const getInitialInput = () => {
      let stateFromLocator = {};
      try {
        stateFromLocator = (0, _url.extractDashboardState)(getScopedHistory().location.state);
      } catch (e) {
        // eslint-disable-next-line no-console
        console.warn('Unable to extract dashboard state from locator. Error: ', e);
      }
      let initialUrlState = {};
      try {
        initialUrlState = (0, _url.loadAndRemoveDashboardState)(kbnUrlStateStorage);
      } catch (e) {
        // eslint-disable-next-line no-console
        console.warn('Unable to extract dashboard state from URL. Error: ', e);
      }

      // Override all state with URL + Locator input
      return {
        // State loaded from the dashboard app URL and from the locator overrides all other dashboard state.
        ...initialUrlState,
        ...stateFromLocator,
        // if print mode is active, force viewMode.PRINT
        ...(_kibana_services.screenshotModeService.isScreenshotMode() && _kibana_services.screenshotModeService.getScreenshotContext('layout') === 'print' ? {
          viewMode: 'print'
        } : {})
      };
    };
    return Promise.resolve({
      getIncomingEmbeddable: () => incomingEmbeddable,
      // integrations
      useSessionStorageIntegration: true,
      useUnifiedSearchIntegration: true,
      unifiedSearchSettings: {
        kbnUrlStateStorage
      },
      useSearchSessionsIntegration: true,
      searchSessionSettings: {
        createSessionRestorationDataProvider: _search_sessions_integration.createSessionRestorationDataProvider,
        sessionIdToRestore: searchSessionIdFromURL,
        sessionIdUrlChangeObservable: (0, _search_sessions_integration.getSessionURLObservable)(history),
        getSearchSessionIdFromURL: () => (0, _search_sessions_integration.getSearchSessionIdFromURL)(history),
        removeSessionIdFromUrl: () => (0, _search_sessions_integration.removeSearchSessionIdFromURL)(kbnUrlStateStorage)
      },
      getInitialInput,
      getPassThroughContext: () => {
        var _getScopedHistory$loc;
        return (_getScopedHistory$loc = getScopedHistory().location.state) === null || _getScopedHistory$loc === void 0 ? void 0 : _getScopedHistory$loc.passThroughContext;
      },
      validateLoadedSavedObject: validateOutcome,
      fullScreenMode: (_kbnUrlStateStorage$g = (_kbnUrlStateStorage$g2 = kbnUrlStateStorage.get(_urls.DASHBOARD_STATE_STORAGE_KEY)) === null || _kbnUrlStateStorage$g2 === void 0 ? void 0 : _kbnUrlStateStorage$g2.fullScreenMode) !== null && _kbnUrlStateStorage$g !== void 0 ? _kbnUrlStateStorage$g : false,
      isEmbeddedExternally: Boolean(embedSettings),
      // embed settings are only sent if the dashboard URL has `embed=true`
      getEmbeddableAppContext: dashboardId => ({
        currentAppId: _constants.DASHBOARD_APP_ID,
        getCurrentPath: () => `#${(0, _urls.createDashboardEditUrl)(dashboardId)}`
      })
    });
  }, [history, embedSettings, validateOutcome, getScopedHistory, kbnUrlStateStorage, incomingEmbeddable]);
  (0, _react.useEffect)(() => {
    if (!dashboardApi) return;
    const {
      stopWatchingExpandedPanel
    } = (0, _url.startSyncingExpandedPanelState)({
      dashboardApi,
      history
    });
    return () => stopWatchingExpandedPanel();
  }, [dashboardApi, history]);

  /**
   * When the dashboard container is created, or re-created, start syncing dashboard state with the URL
   */
  (0, _react.useEffect)(() => {
    if (!dashboardApi) return;
    const appStateSubscription = kbnUrlStateStorage.change$(_urls.DASHBOARD_STATE_STORAGE_KEY).pipe((0, _rxjs.debounceTime)(10)) // debounce URL updates so react has time to unsubscribe when changing URLs
    .subscribe(() => {
      const rawAppStateInUrl = kbnUrlStateStorage.get(_urls.DASHBOARD_STATE_STORAGE_KEY);
      if (rawAppStateInUrl) setRegenerateId((0, _uuid.v4)());
    });
    return () => appStateSubscription.unsubscribe();
  }, [dashboardApi, kbnUrlStateStorage, savedDashboardId]);
  const locator = (0, _react.useMemo)(() => _kibana_services.shareService === null || _kibana_services.shareService === void 0 ? void 0 : _kibana_services.shareService.url.locators.get(_deeplinksAnalytics.DASHBOARD_APP_LOCATOR), []);
  return showNoDataPage ? /*#__PURE__*/_react.default.createElement(_dashboard_app_no_data.DashboardAppNoDataPage, {
    onDataViewCreated: () => setShowNoDataPage(false),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, dashboardApi && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_dashboard_tab_title_setter.DashboardTabTitleSetter, {
    dashboardApi: dashboardApi,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_dashboard_top_nav.DashboardTopNav, {
    redirectTo: redirectTo,
    embedSettings: embedSettings,
    dashboardApi: dashboardApi,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 11
    }
  })), getLegacyConflictWarning === null || getLegacyConflictWarning === void 0 ? void 0 : getLegacyConflictWarning(), /*#__PURE__*/_react.default.createElement(_dashboard_renderer.DashboardRenderer, {
    key: regenerateId,
    locator: locator,
    onApiAvailable: dashboard => {
      if (dashboard && !dashboardApi) {
        setDashboardApi(dashboard);
        if (expandedPanelId) {
          dashboard === null || dashboard === void 0 ? void 0 : dashboard.expandPanel(expandedPanelId);
        }
      }
    },
    dashboardRedirect: redirectTo,
    savedObjectId: savedDashboardId,
    showPlainSpinner: showPlainSpinner,
    getCreationOptions: getCreationOptions,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 7
    }
  }));
}