"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDashboardBackupService = exports.DASHBOARD_PANELS_UNSAVED_ID = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-utils-plugin/public");
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _kibana_services = require("./kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DASHBOARD_PANELS_UNSAVED_ID = exports.DASHBOARD_PANELS_UNSAVED_ID = 'unsavedDashboard';
const DASHBOARD_VIEWMODE_LOCAL_KEY = 'dashboardViewMode';

// this key is named `panels` for BWC reasons, but actually contains the entire dashboard state
const DASHBOARD_STATE_SESSION_KEY = 'dashboardStateManagerPanels';
const getPanelsGetError = message => _i18n.i18n.translate('dashboard.panelStorageError.getError', {
  defaultMessage: 'Error encountered while fetching unsaved changes: {message}',
  values: {
    message
  }
});
class DashboardBackupService {
  constructor() {
    (0, _defineProperty2.default)(this, "activeSpaceId", void 0);
    (0, _defineProperty2.default)(this, "sessionStorage", void 0);
    (0, _defineProperty2.default)(this, "localStorage", void 0);
    (0, _defineProperty2.default)(this, "prevDashboardIdsWithUnsavedChanges", []);
    (0, _defineProperty2.default)(this, "getViewMode", () => {
      var _this$localStorage$ge;
      return (_this$localStorage$ge = this.localStorage.get(DASHBOARD_VIEWMODE_LOCAL_KEY)) !== null && _this$localStorage$ge !== void 0 ? _this$localStorage$ge : 'view';
    });
    (0, _defineProperty2.default)(this, "storeViewMode", viewMode => {
      try {
        this.localStorage.set(DASHBOARD_VIEWMODE_LOCAL_KEY, viewMode);
      } catch (e) {
        _kibana_services.coreServices.notifications.toasts.addDanger({
          title: _i18n.i18n.translate('dashboard.viewmodeBackup.error', {
            defaultMessage: 'Error encountered while backing up view mode: {message}',
            values: {
              message: e.message
            }
          }),
          'data-test-subj': 'dashboardViewmodeBackupFailure'
        });
      }
    });
    this.sessionStorage = new _public.Storage(sessionStorage);
    this.localStorage = new _public.Storage(localStorage);
    this.activeSpaceId = 'default';
    if (_kibana_services.spacesService) {
      (0, _rxjs.firstValueFrom)(_kibana_services.spacesService.getActiveSpace$()).then(space => {
        this.activeSpaceId = space.id;
      });
    }
  }
  clearState(id = DASHBOARD_PANELS_UNSAVED_ID) {
    try {
      var _this$sessionStorage$;
      const allSpaces = (_this$sessionStorage$ = this.sessionStorage.get(DASHBOARD_STATE_SESSION_KEY)) !== null && _this$sessionStorage$ !== void 0 ? _this$sessionStorage$ : {};
      const dashboards = this.getDashboards();
      if (dashboards[id]) {
        delete dashboards[id];
        this.sessionStorage.set(DASHBOARD_STATE_SESSION_KEY, {
          ...allSpaces,
          [this.activeSpaceId]: dashboards
        });
      }
    } catch (e) {
      _kibana_services.coreServices.notifications.toasts.addDanger({
        title: _i18n.i18n.translate('dashboard.panelStorageError.clearError', {
          defaultMessage: 'Error encountered while clearing unsaved changes: {message}',
          values: {
            message: e.message
          }
        }),
        'data-test-subj': 'dashboardPanelsClearFailure'
      });
    }
  }
  getState(id = DASHBOARD_PANELS_UNSAVED_ID) {
    try {
      const dashboards = this.getDashboards();
      return dashboards[id];
    } catch (e) {
      _kibana_services.coreServices.notifications.toasts.addDanger({
        title: getPanelsGetError(e.message),
        'data-test-subj': 'dashboardPanelsGetFailure'
      });
    }
  }
  setState(id = DASHBOARD_PANELS_UNSAVED_ID, backupState) {
    try {
      var _this$sessionStorage$2;
      const allSpaces = (_this$sessionStorage$2 = this.sessionStorage.get(DASHBOARD_STATE_SESSION_KEY)) !== null && _this$sessionStorage$2 !== void 0 ? _this$sessionStorage$2 : {};
      (0, _saferLodashSet.set)(allSpaces, [this.activeSpaceId, id], backupState);
      this.sessionStorage.set(DASHBOARD_STATE_SESSION_KEY, allSpaces);
    } catch (e) {
      _kibana_services.coreServices.notifications.toasts.addDanger({
        title: _i18n.i18n.translate('dashboard.panelStorageError.setError', {
          defaultMessage: 'Error encountered while setting unsaved changes: {message}',
          values: {
            message: e.message
          }
        }),
        'data-test-subj': 'dashboardPanelsSetFailure'
      });
    }
  }
  getDashboardIdsWithUnsavedChanges() {
    try {
      const dashboards = this.getDashboards();
      const dashboardIdsWithUnsavedChanges = Object.keys(dashboards).filter(dashboardId => {
        return hasUnsavedEdits(dashboards[dashboardId]);
      });

      /**
       * Because we are storing these unsaved dashboard IDs in React component state, we only want things to be re-rendered
       * if the **contents** change, not if the array reference changes
       */
      if ((0, _lodash.isEqual)(this.prevDashboardIdsWithUnsavedChanges, dashboardIdsWithUnsavedChanges)) {
        return this.prevDashboardIdsWithUnsavedChanges;
      }
      this.prevDashboardIdsWithUnsavedChanges = dashboardIdsWithUnsavedChanges;
      return dashboardIdsWithUnsavedChanges;
    } catch (e) {
      _kibana_services.coreServices.notifications.toasts.addDanger({
        title: getPanelsGetError(e.message),
        'data-test-subj': 'dashboardPanelsGetFailure'
      });
      return [];
    }
  }
  dashboardHasUnsavedEdits(id = DASHBOARD_PANELS_UNSAVED_ID) {
    const dashboards = this.getDashboards();
    return hasUnsavedEdits(dashboards[id]);
  }
  getDashboards() {
    var _this$sessionStorage$3, _this$sessionStorage$4;
    return (_this$sessionStorage$3 = (_this$sessionStorage$4 = this.sessionStorage.get(DASHBOARD_STATE_SESSION_KEY)) === null || _this$sessionStorage$4 === void 0 ? void 0 : _this$sessionStorage$4[this.activeSpaceId]) !== null && _this$sessionStorage$3 !== void 0 ? _this$sessionStorage$3 : {};
  }
}
function hasUnsavedEdits(backupState) {
  return backupState ? backupState.viewMode === 'edit' && Object.keys(backupState).some(stateKey => stateKey !== 'viewMode' && stateKey !== 'references') : false;
}
let dashboardBackupService;
const getDashboardBackupService = () => {
  if (!dashboardBackupService) {
    dashboardBackupService = new DashboardBackupService();
  }
  return dashboardBackupService;
};
exports.getDashboardBackupService = getDashboardBackupService;