"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toAsyncKibanaSearchResponse = toAsyncKibanaSearchResponse;
exports.toAsyncKibanaSearchStatusResponse = toAsyncKibanaSearchStatusResponse;
var _sanitize_request_params = require("../../sanitize_request_params");
var _common = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Get the Kibana representation of an async search status response.
 */
function toAsyncKibanaSearchStatusResponse(response, warning) {
  return {
    id: response.id,
    rawResponse: {},
    isPartial: response.is_partial,
    isRunning: response.is_running,
    ...(warning ? {
      warning
    } : {})
  };
}

/**
 * Get the Kibana representation of an async search response.
 */
function toAsyncKibanaSearchResponse(response, headers, requestParams, options) {
  return {
    id: headers['x-elasticsearch-async-id'],
    rawResponse: response.response ? (0, _common.shimHitsTotal)(response.response, options) : response,
    isPartial: headers['x-elasticsearch-async-is-running'] === '?1',
    isRunning: headers['x-elasticsearch-async-is-running'] === '?1',
    ...(headers.warning ? {
      warning: headers.warning
    } : {}),
    ...(requestParams ? {
      requestParams: (0, _sanitize_request_params.sanitizeRequestParams)(requestParams)
    } : {}),
    ...(response.response ? (0, _common.getTotalLoaded)(response.response) : {})
  };
}