"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataUsageService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _configSchema = require("@kbn/config-schema");
var _errors = require("../errors");
var _autoops_api = require("./autoops_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DataUsageService {
  constructor(logger) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = logger;
  }
  async getMetrics({
    from,
    to,
    metricTypes,
    dataStreams
  }) {
    try {
      const autoOpsAPIService = new _autoops_api.AutoOpsAPIService(this.logger);
      const response = await autoOpsAPIService.autoOpsUsageMetricsAPI({
        from,
        to,
        metricTypes,
        dataStreams
      });
      return response;
    } catch (error) {
      if (error instanceof _configSchema.ValidationError) {
        throw new _errors.AutoOpsError(error.message);
      }
      throw error;
    }
  }
}
exports.DataUsageService = DataUsageService;