"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isNumericDriftData = exports.isCategoricalDriftData = exports.getDefaultDataComparisonState = exports.FETCH_STATUS = void 0;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _mlQueryUtils = require("@kbn/ml-query-utils");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultSearchQuery = {
  match_all: {}
};
const getDefaultDataComparisonState = overrides => ({
  searchString: '',
  searchQuery: defaultSearchQuery,
  searchQueryLanguage: _mlQueryUtils.SEARCH_QUERY_LANGUAGE.KUERY,
  filters: [],
  reference: {
    searchString: '',
    searchQuery: defaultSearchQuery,
    searchQueryLanguage: _mlQueryUtils.SEARCH_QUERY_LANGUAGE.KUERY,
    filters: []
  },
  comparison: {
    searchString: '',
    searchQuery: defaultSearchQuery,
    searchQueryLanguage: _mlQueryUtils.SEARCH_QUERY_LANGUAGE.KUERY,
    filters: []
  },
  ...overrides
});

// Show the overview table
exports.getDefaultDataComparisonState = getDefaultDataComparisonState;
let FETCH_STATUS = exports.FETCH_STATUS = /*#__PURE__*/function (FETCH_STATUS) {
  FETCH_STATUS["LOADING"] = "loading";
  FETCH_STATUS["SUCCESS"] = "success";
  FETCH_STATUS["FAILURE"] = "failure";
  FETCH_STATUS["NOT_INITIATED"] = "not_initiated";
  return FETCH_STATUS;
}({});
const isNumericDriftData = arg => {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['type']) && arg.type === _constants.DATA_COMPARISON_TYPE.NUMERIC;
};
exports.isNumericDriftData = isNumericDriftData;
const isCategoricalDriftData = arg => {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['type']) && arg.type === _constants.DATA_COMPARISON_TYPE.CATEGORICAL;
};
exports.isCategoricalDriftData = isCategoricalDriftData;