"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchDataWithTimeout = void 0;
exports.rateLimitingForkJoin = rateLimitingForkJoin;
var _rxjs = require("rxjs");
var _index_data_visualizer_viewer = require("../../constants/index_data_visualizer_viewer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchDataWithTimeout = async (asyncFunc, abortCtrl, defaultResult = null, timeoutDuration = 6000) => {
  return await (0, _rxjs.lastValueFrom)((0, _rxjs.from)(asyncFunc).pipe((0, _rxjs.timeout)(timeoutDuration), (0, _rxjs.catchError)(error => {
    // eslint-disable-next-line no-console
    console.error('Error occured in fetchDataWithTimeout', error);
    abortCtrl.abort();
    return (0, _rxjs.of)(defaultResult);
  })));
};
/**
 * Helper function to run forkJoin
 * with restrictions on how many input observables can be subscribed to concurrently
 */
exports.fetchDataWithTimeout = fetchDataWithTimeout;
function rateLimitingForkJoin(observables, maxConcurrentRequests = _index_data_visualizer_viewer.MAX_CONCURRENT_REQUESTS) {
  return (0, _rxjs.from)(observables).pipe((0, _rxjs.mergeMap)((observable, index) => observable.pipe((0, _rxjs.last)(), (0, _rxjs.map)(value => ({
    index,
    value
  }))), maxConcurrentRequests), (0, _rxjs.toArray)(), (0, _rxjs.map)(indexedObservables => indexedObservables.sort((l, r) => l.index - r.index).map(obs => obs.value)));
}