"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationIcon = void 0;
var _eui = require("@elastic/eui");
var _public = require("@kbn/fleet-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../common/constants");
var _logging = _interopRequireDefault(require("../../icons/logging.svg"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/common/integration_icon.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const IntegrationIcon = ({
  integration
}) => {
  return integration && integration.name !== _constants.NONE ? /*#__PURE__*/_react.default.createElement(_public.PackageIcon, {
    packageName: integration.name,
    version: integration.version,
    icons: integration.icons,
    size: "m",
    tryApi: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: _logging.default,
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  });
};
exports.IntegrationIcon = IntegrationIcon;