"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDatasetQualityState = void 0;
var _react = require("@xstate/react");
var _context = require("../components/dataset_quality/context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDatasetQualityState = () => {
  var _useSelector, _Object$values, _datasetUserPrivilege, _Object$values2, _datasetUserPrivilege2, _Object$values3, _datasetUserPrivilege3;
  const {
    service
  } = (0, _context.useDatasetQualityContext)();
  const {
    datasetUserPrivileges
  } = (_useSelector = (0, _react.useSelector)(service, state => state.context)) !== null && _useSelector !== void 0 ? _useSelector : {};
  const statsLoading = (0, _react.useSelector)(service, state => state.matches('initializing') || state.matches('main.stats.datasets.fetching'));
  const canUserReadFailureStore = Boolean((_Object$values = Object.values((_datasetUserPrivilege = datasetUserPrivileges === null || datasetUserPrivileges === void 0 ? void 0 : datasetUserPrivileges.datasetsPrivilages) !== null && _datasetUserPrivilege !== void 0 ? _datasetUserPrivilege : {})) === null || _Object$values === void 0 ? void 0 : _Object$values.some(privilege => privilege.canReadFailureStore));
  const canUserMonitorAnyDataset = Boolean((_Object$values2 = Object.values((_datasetUserPrivilege2 = datasetUserPrivileges === null || datasetUserPrivileges === void 0 ? void 0 : datasetUserPrivileges.datasetsPrivilages) !== null && _datasetUserPrivilege2 !== void 0 ? _datasetUserPrivilege2 : {})) === null || _Object$values2 === void 0 ? void 0 : _Object$values2.some(privilege => privilege.canMonitor));
  const canUserReadAnyDataset = Boolean((_Object$values3 = Object.values((_datasetUserPrivilege3 = datasetUserPrivileges === null || datasetUserPrivileges === void 0 ? void 0 : datasetUserPrivileges.datasetsPrivilages) !== null && _datasetUserPrivilege3 !== void 0 ? _datasetUserPrivilege3 : {})) === null || _Object$values3 === void 0 ? void 0 : _Object$values3.some(privilege => privilege.canRead));
  return {
    statsLoading,
    canUserReadFailureStore,
    canUserMonitorAnyDataset,
    canUserReadAnyDataset
  };
};
exports.useDatasetQualityState = useDatasetQualityState;