"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFailureStoreModal = useFailureStoreModal;
var _react = _interopRequireWildcard(require("react"));
var _failureStoreModal = require("@kbn/failure-store-modal");
var _use_dataset_quality_details_state = require("./use_dataset_quality_details_state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFailureStoreModal() {
  const {
    canUserReadFailureStore,
    hasFailureStore,
    defaultRetentionPeriod,
    customRetentionPeriod,
    updateFailureStore,
    canUserManageFailureStore
  } = (0, _use_dataset_quality_details_state.useDatasetQualityDetailsState)();
  const [isFailureStoreModalOpen, setIsFailureStoreModalOpen] = (0, _react.useState)(false);
  const openModal = () => {
    setIsFailureStoreModalOpen(true);
  };
  const closeModal = () => {
    setIsFailureStoreModalOpen(false);
  };
  const handleSaveModal = async data => {
    updateFailureStore({
      failureStoreEnabled: data.failureStoreEnabled,
      customRetentionPeriod: data.customRetentionPeriod
    });
    closeModal();
  };
  const renderModal = () => {
    if (canUserManageFailureStore && isFailureStoreModalOpen) {
      return /*#__PURE__*/_react.default.createElement(_failureStoreModal.FailureStoreModal, {
        onCloseModal: closeModal,
        onSaveModal: handleSaveModal,
        failureStoreProps: {
          failureStoreEnabled: hasFailureStore,
          defaultRetentionPeriod,
          customRetentionPeriod
        }
      });
    }
    return null;
  };
  return {
    isFailureStoreModalOpen,
    openModal,
    closeModal,
    handleSaveModal,
    canUserReadFailureStore,
    canUserManageFailureStore,
    hasFailureStore,
    defaultRetentionPeriod,
    customRetentionPeriod,
    renderModal
  };
}