"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverGridFlyout = DiscoverGridFlyout;
exports.default = exports.FLYOUT_WIDTH_KEY = void 0;
var _react = _interopRequireWildcard(require("react"));
var _esQuery = require("@kbn/es-query");
var _discoverUtils = require("@kbn/discover-utils");
var _public = require("@kbn/unified-doc-viewer-plugin/public");
var _use_discover_services = require("../../hooks/use_discover_services");
var _use_flyout_actions = require("./use_flyout_actions");
var _customizations = require("../../customizations");
var _discover_grid_flyout_actions = require("./discover_grid_flyout_actions");
var _context_awareness = require("../../context_awareness");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/discover/public/components/discover_grid_flyout/discover_grid_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FLYOUT_WIDTH_KEY = exports.FLYOUT_WIDTH_KEY = 'discover:flyoutWidth';
/**
 * Flyout displaying an expanded Elasticsearch document
 */
function DiscoverGridFlyout({
  hit,
  hits,
  dataView,
  columns,
  columnsMeta,
  savedSearchId,
  filters,
  query,
  onFilter,
  onClose,
  onRemoveColumn,
  onAddColumn,
  setExpandedDoc,
  initialTabId,
  docViewerRef
}) {
  const services = (0, _use_discover_services.useDiscoverServices)();
  const flyoutCustomization = (0, _customizations.useDiscoverCustomization)('flyout');
  const isESQLQuery = (0, _esQuery.isOfAggregateQueryType)(query);
  // Get actual hit with updated highlighted searches
  const actualHit = (0, _react.useMemo)(() => (hits === null || hits === void 0 ? void 0 : hits.find(({
    id
  }) => id === (hit === null || hit === void 0 ? void 0 : hit.id))) || hit, [hit, hits]);
  const {
    flyoutActions
  } = (0, _use_flyout_actions.useFlyoutActions)({
    actions: flyoutCustomization === null || flyoutCustomization === void 0 ? void 0 : flyoutCustomization.actions,
    dataView,
    rowIndex: actualHit.raw._index,
    rowId: actualHit.raw._id,
    columns,
    filters,
    savedSearchId
  });
  const getDocViewerAccessor = (0, _context_awareness.useProfileAccessor)('getDocViewer', {
    record: actualHit
  });
  const docViewer = (0, _react.useMemo)(() => {
    const getDocViewer = getDocViewerAccessor(() => ({
      title: flyoutCustomization === null || flyoutCustomization === void 0 ? void 0 : flyoutCustomization.title,
      docViewsRegistry: registry => typeof (flyoutCustomization === null || flyoutCustomization === void 0 ? void 0 : flyoutCustomization.docViewsRegistry) === 'function' ? flyoutCustomization.docViewsRegistry(registry) : registry
    }));
    return getDocViewer({
      record: actualHit
    });
  }, [getDocViewerAccessor, actualHit, flyoutCustomization]);
  (0, _react.useEffect)(() => {
    (0, _discoverUtils.dismissAllFlyoutsExceptFor)(_discoverUtils.DiscoverFlyouts.docViewer);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_public.UnifiedDocViewerFlyout, {
    flyoutTitle: docViewer.title,
    flyoutDefaultWidth: flyoutCustomization === null || flyoutCustomization === void 0 ? void 0 : flyoutCustomization.size,
    flyoutActions: !isESQLQuery && flyoutActions.length > 0 ? /*#__PURE__*/_react.default.createElement(_discover_grid_flyout_actions.DiscoverGridFlyoutActions, {
      flyoutActions: flyoutActions,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 11
      }
    }) : null,
    flyoutWidthLocalStorageKey: FLYOUT_WIDTH_KEY,
    FlyoutCustomBody: flyoutCustomization === null || flyoutCustomization === void 0 ? void 0 : flyoutCustomization.Content,
    services: services,
    docViewsRegistry: docViewer.docViewsRegistry,
    isEsqlQuery: isESQLQuery,
    hit: hit,
    hits: hits,
    dataView: dataView,
    columns: columns,
    columnsMeta: columnsMeta,
    onAddColumn: onAddColumn,
    onRemoveColumn: onRemoveColumn,
    onClose: onClose,
    onFilter: onFilter,
    setExpandedDoc: setExpandedDoc,
    initialTabId: initialTabId,
    docViewerRef: docViewerRef,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 5
    }
  });
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = DiscoverGridFlyout;