"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSecurityDocumentProfileProvider = void 0;
var _discoverUtils = require("@kbn/discover-utils");
var _profiles = require("../../../profiles");
var _constants = require("../constants");
var i18n = _interopRequireWildcard(require("../translations"));
var _components = require("../components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createSecurityDocumentProfileProvider = _services => {
  return {
    profileId: _constants.SECURITY_PROFILE_ID.document,
    experimental: true,
    profile: {
      getDocViewer: prev => params => {
        const prevDocViewer = prev(params);
        const isAlert = (0, _discoverUtils.getFieldValue)(params.record, 'event.kind') === 'signal';
        return {
          ...prevDocViewer,
          docViewsRegistry: registry => {
            registry.add({
              id: 'doc_view_alerts_overview',
              title: i18n.overviewTabTitle(isAlert),
              order: 0,
              component: _components.AlertEventOverviewLazy
            });
            return prevDocViewer.docViewsRegistry(registry);
          }
        };
      }
    },
    resolve: ({
      rootContext
    }) => {
      if (rootContext.solutionType !== _profiles.SolutionType.Security) {
        return {
          isMatch: false
        };
      }
      return {
        isMatch: true,
        context: {
          type: _profiles.DocumentType.Default
        }
      };
    }
  };
};
exports.createSecurityDocumentProfileProvider = createSecurityDocumentProfileProvider;