"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataView = void 0;
var _react = require("react");
var _use_discover_services = require("./use_discover_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const useDataView = ({
  index
}) => {
  const {
    dataViews
  } = (0, _use_discover_services.useDiscoverServices)();
  const [dataView, setDataView] = (0, _react.useState)();
  const [error, setError] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const promise = typeof index === 'object' ? dataViews.create(index) : dataViews.get(index);
    promise.then(setDataView).catch(setError);
  }, [dataViews, index]);
  return {
    dataView,
    error
  };
};
exports.useDataView = useDataView;