"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createApmContextService = void 0;
var _traces = require("../traces");
var _errors_context_service = require("./errors/errors_context_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

let indicesPromise = null;
const getCachedApmIndices = apmSourcesAccess => {
  if (indicesPromise) {
    return indicesPromise;
  }
  indicesPromise = (async () => {
    try {
      return await apmSourcesAccess.getApmIndices();
    } catch (error) {
      indicesPromise = null;
      return null;
    }
  })();
  return indicesPromise;
};
const createApmContextService = async ({
  apmSourcesAccess
}) => {
  const indices = apmSourcesAccess ? await getCachedApmIndices(apmSourcesAccess) : null;
  return {
    tracesService: (0, _traces.createTracesContextService)({
      indices
    }),
    errorsService: (0, _errors_context_service.createErrorsContextService)({
      indices
    })
  };
};
exports.createApmContextService = createApmContextService;