"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenerationInterval = exports.FindAttackDiscoveryAlertsParams = exports.CreateAttackDiscoveryAlertsParams = exports.AttackDiscoveryStatusEnum = exports.AttackDiscoveryStatus = exports.AttackDiscoveryStats = exports.AttackDiscoveryStat = exports.AttackDiscoveryResponse = exports.AttackDiscoveryGenerationConfig = exports.AttackDiscovery = exports.AttackDiscoveries = void 0;
var _zod = require("@kbn/zod");
var _common_attributes = require("../common_attributes.gen");
var _common_attributes2 = require("../conversations/common_attributes.gen");
var _bulk_crud_anonymization_fields_route = require("../anonymization_fields/bulk_crud_anonymization_fields_route.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Common Attack Discovery Attributes
 *   version: not applicable
 */

/**
 * An attack discovery generated from one or more alerts
 */

const AttackDiscovery = exports.AttackDiscovery = _zod.z.object({
  /**
   * The alert IDs that the attack discovery is based on
   */
  alertIds: _zod.z.array(_zod.z.string()),
  /**
   * UUID of attack discovery
   */
  id: _zod.z.string().optional(),
  /**
   * Details of the attack with bulleted markdown that always uses special syntax for field names and values from the source data.
   */
  detailsMarkdown: _zod.z.string(),
  /**
   * A short (no more than a sentence) summary of the attack discovery featuring only the host.name and user.name fields (when they are applicable), using the same syntax
   */
  entitySummaryMarkdown: _zod.z.string().optional(),
  /**
   * An array of MITRE ATT&CK tactic for the attack discovery
   */
  mitreAttackTactics: _zod.z.array(_zod.z.string()).optional(),
  /**
   * A markdown summary of attack discovery, using the same syntax
   */
  summaryMarkdown: _zod.z.string(),
  /**
   * A title for the attack discovery, in plain text
   */
  title: _zod.z.string(),
  /**
   * The time the attack discovery was generated
   */
  timestamp: _common_attributes.NonEmptyTimestamp.optional()
});

/**
 * Array of attack discoveries
 */

const AttackDiscoveries = exports.AttackDiscoveries = _zod.z.array(AttackDiscovery);

/**
 * The status of the attack discovery.
 */

const AttackDiscoveryStatus = exports.AttackDiscoveryStatus = _zod.z.enum(['running', 'succeeded', 'failed', 'canceled']);
const AttackDiscoveryStatusEnum = exports.AttackDiscoveryStatusEnum = AttackDiscoveryStatus.enum;

/**
 * Run durations for the attack discovery
 */

const GenerationInterval = exports.GenerationInterval = _zod.z.object({
  /**
   * The time the attack discovery was generated
   */
  date: _zod.z.string(),
  /**
   * The duration of the attack discovery generation
   */
  durationMs: _zod.z.number().int()
});

/**
 * Attack discovery stats
 */

const AttackDiscoveryStat = exports.AttackDiscoveryStat = _zod.z.object({
  /**
   * Whether the user has viewed the results of the attack discovery run
   */
  hasViewed: _zod.z.boolean(),
  /**
   * The number of attack discoveries for the connector
   */
  count: _zod.z.number().int(),
  /**
   * The connector ID for the attack discovery
   */
  connectorId: _zod.z.string(),
  /**
   * The status of the attack discovery.
   */
  status: AttackDiscoveryStatus
});

/**
 * Stats on existing attack discovery documents
 */

const AttackDiscoveryStats = exports.AttackDiscoveryStats = _zod.z.object({
  /**
   * The number of attack discoveries that have not yet been viewed
   */
  newDiscoveriesCount: _zod.z.number().int(),
  /**
   * The number of connectors with new results that have not yet been viewed
   */
  newConnectorResultsCount: _zod.z.number().int(),
  /**
   * Attack discovery stats per connector
   */
  statsPerConnector: _zod.z.array(AttackDiscoveryStat)
});
const AttackDiscoveryResponse = exports.AttackDiscoveryResponse = _zod.z.object({
  id: _common_attributes.NonEmptyString,
  timestamp: _common_attributes.NonEmptyString.optional(),
  /**
   * The last time attack discovery was updated.
   */
  updatedAt: _zod.z.string(),
  /**
   * The last time attack discovery was viewed in the browser.
   */
  lastViewedAt: _zod.z.string(),
  /**
   * The number of alerts in the context.
   */
  alertsContextCount: _zod.z.number().int().optional(),
  /**
   * The time attack discovery was created.
   */
  createdAt: _zod.z.string(),
  replacements: _common_attributes2.Replacements.optional(),
  users: _zod.z.array(_common_attributes.User),
  /**
   * The status of the attack discovery.
   */
  status: AttackDiscoveryStatus,
  /**
   * The attack discoveries.
   */
  attackDiscoveries: AttackDiscoveries,
  /**
   * LLM API configuration.
   */
  apiConfig: _common_attributes2.ApiConfig,
  /**
   * Kibana space
   */
  namespace: _zod.z.string(),
  /**
   * The backing index required for update requests.
   */
  backingIndex: _zod.z.string(),
  /**
   * The most 5 recent generation intervals
   */
  generationIntervals: _zod.z.array(GenerationInterval),
  /**
   * The average generation interval in milliseconds
   */
  averageIntervalMs: _zod.z.number().int(),
  /**
   * The reason for a status of failed.
   */
  failureReason: _zod.z.string().optional()
});
const CreateAttackDiscoveryAlertsParams = exports.CreateAttackDiscoveryAlertsParams = _zod.z.object({
  /**
   * The number of alerts provided as context to the LLM
   */
  alertsContextCount: _zod.z.number().int(),
  /**
   * The anonymized alerts that were used to generate the attack discovery
   */
  anonymizedAlerts: _zod.z.array(_zod.z.object({
    id: _zod.z.string().optional(),
    metadata: _zod.z.object({}),
    pageContent: _zod.z.string()
  })),
  /**
   * LLM API configuration
   */
  apiConfig: _common_attributes2.ApiConfig,
  /**
   * The generated Attack discoveries
   */
  attackDiscoveries: AttackDiscoveries,
  /**
   * The name of the connector that generated the attack discovery
   */
  connectorName: _zod.z.string(),
  /**
   * Enables a markdown syntax used to render pivot fields, for example `{{ user.name james }}`. When disabled, the same example would be rendered as `james`. This is primarily used for Attack discovery views within Kibana. Defaults to `false`.
   */
  enableFieldRendering: _zod.z.boolean(),
  /**
   * The generation ID of the run that created the attack discovery
   */
  generationUuid: _zod.z.string(),
  /**
   * Replacements enable anonymization of data sent to the LLM. When Attack discoveries are added to an assistant conversation, replacements must be provided at the same time.
   */
  replacements: _common_attributes2.Replacements.optional(),
  /**
   * When true, return the created Attack discoveries with text replacements applied to the detailsMarkdown, entitySummaryMarkdown, summaryMarkdown, and title fields.
   */
  withReplacements: _zod.z.boolean()
});
const FindAttackDiscoveryAlertsParams = exports.FindAttackDiscoveryAlertsParams = _zod.z.object({
  /**
   * filter by alert IDs within Attack discovery
   */
  alertIds: _zod.z.array(_zod.z.string()).optional(),
  /**
   * filter by connector names
   */
  connectorNames: _zod.z.array(_zod.z.string()).optional(),
  /**
   * Enables a markdown syntax used to render pivot fields, for example `{{ user.name james }}`. When disabled, the same example would be rendered as `james`. This is primarily used for Attack discovery views within Kibana. Defaults to `false`.
   */
  enableFieldRendering: _zod.z.boolean(),
  /**
   * filter by end date (relative or absolute)
   */
  end: _zod.z.string().optional(),
  /**
   * filter by execution UUID
   */
  executionUuid: _zod.z.string().optional(),
  /**
   * whether to include attack alert IDs in the response
   */
  includeUniqueAlertIds: _zod.z.boolean().optional(),
  /**
   * filter by Attack discovery IDs
   */
  ids: _zod.z.array(_zod.z.string()).optional(),
  page: _zod.z.number().int().min(1).optional().default(1),
  perPage: _zod.z.number().int().min(0).optional().default(10),
  /**
   * filter by search query
   */
  search: _zod.z.string().optional(),
  /**
   * `undefined`: show both shared, and only visible to me Attack discoveries. `true`: show only shared Attack discoveries. `false`: show only visible to me Attack discoveries.
   */
  shared: _zod.z.boolean().optional(),
  sortField: _zod.z.string().optional().default('@timestamp'),
  sortOrder: _zod.z.string().optional(),
  /**
   * filter by start date (relative or absolute)
   */
  start: _zod.z.string().optional(),
  /**
   * filter by kibana.alert.workflow.status
   */
  status: _zod.z.array(_zod.z.string()).optional(),
  /**
   * When true, return the created Attack discoveries with text replacements applied to the detailsMarkdown, entitySummaryMarkdown, summaryMarkdown, and title fields.
   */
  withReplacements: _zod.z.boolean()
});
const AttackDiscoveryGenerationConfig = exports.AttackDiscoveryGenerationConfig = _zod.z.object({
  /** 
      * The (space specific) index pattern that contains the alerts to use as
  context for the attack discovery.
  Example: .alerts-security.alerts-default
        */
  alertsIndexPattern: _zod.z.string(),
  /**
   * The list of fields, and whether or not they are anonymized, allowed to be sent to LLMs. Consider using the output of the `/api/security_ai_assistant/anonymization_fields/_find` API (for a specific Kibana space) to provide this value.
   */
  anonymizationFields: _zod.z.array(_bulk_crud_anonymization_fields_route.AnonymizationFieldResponse),
  /**
   * LLM API configuration.
   */
  apiConfig: _common_attributes2.ApiConfig,
  connectorName: _zod.z.string().optional(),
  end: _zod.z.string().optional(),
  /** 
      * An Elasticsearch-style query DSL object used to filter alerts. For example:
  ```json {
  "filter": {
    "bool": {
      "must": [],
      "filter": [
        {
          "bool": {
            "should": [
              {
                "term": {
                  "user.name": { "value": "james" }
                }
              }
            ],
            "minimum_should_match": 1
          }
        }
      ],
      "should": [],
      "must_not": []
    }
  }
  } ``` 
      */
  filter: _zod.z.object({}).catchall(_zod.z.unknown()).optional(),
  langSmithProject: _zod.z.string().optional(),
  langSmithApiKey: _zod.z.string().optional(),
  model: _zod.z.string().optional(),
  replacements: _common_attributes2.Replacements.optional(),
  size: _zod.z.number(),
  start: _zod.z.string().optional(),
  subAction: _zod.z.enum(['invokeAI', 'invokeStream'])
});