"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindAttackDiscoverySchedulesResponse = exports.FindAttackDiscoverySchedulesRequestQuery = void 0;
var _zod = require("@kbn/zod");
var _common_attributes = require("../../../../../common_attributes.gen");
var _schedules_api = require("../schedules_api.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Find Attack Discovery Schedules API endpoint
 *   version: 2023-10-31
 */

const FindAttackDiscoverySchedulesRequestQuery = exports.FindAttackDiscoverySchedulesRequestQuery = _zod.z.object({
  /**
   * Page number to return (used for pagination). Defaults to 1.
   */
  page: _zod.z.coerce.number().optional(),
  /**
   * Number of Attack discovery schedules to return per page (used for pagination). Defaults to 10.
   */
  per_page: _zod.z.coerce.number().optional(),
  /**
   * Field used to sort results. Common fields include 'name', 'created_at', 'updated_at', and 'enabled'.
   */
  sort_field: _common_attributes.NonEmptyString.optional(),
  /**
   * Sort order direction. Use 'asc' for ascending or 'desc' for descending. Defaults to 'asc'.
   */
  sort_direction: _zod.z.enum(['asc', 'desc']).optional()
});
const FindAttackDiscoverySchedulesResponse = exports.FindAttackDiscoverySchedulesResponse = _zod.z.object({
  /**
   * Current page number of the paginated result set.
   */
  page: _zod.z.number(),
  /**
   * Number of items requested per page.
   */
  per_page: _zod.z.number(),
  /**
   * Total number of Attack discovery schedules matching the query (across all pages).
   */
  total: _zod.z.number(),
  /**
   * Array of matched Attack discovery schedule objects.
   */
  data: _zod.z.array(_schedules_api.AttackDiscoveryApiSchedule)
});